\name{refund-package}
\Rdversion{1.1}
\alias{refund-package}
\alias{refund}
\docType{package}
\title{
Regression with Functional Data
}
\description{
Functions for regression with functional data.  The methods currently implemented can be divided into (I) regression of scalar responses on functional predictors, and (II) regression of functional responses on scalar predictors.  Methods of type (I) include penalized functional regression (Goldsmith et al., 2011) and its longitudinal extension (Goldsmith et al., 2010), as well as functional principal component regression (Reiss and Ogden, 2007).  Category (II) includes the penalized OLS and penalized GLS methods of Reiss et al. (2010).}
\details{For a complete list of functions type \code{library(help=refund)}.
}

\author{
Philip Reiss \email{phil.reiss@nyumc.org}, Lei Huang \email{huangracer@gmail.com}, and Jeff Goldsmith \email{jgoldsmi@jhsph.edu}

Maintainer: Lei Huang \email{huangracer@gmail.com}
}
\references{
Goldsmith, J., Bobb, J., Crainiceanu, C., Caffo, B., and Reich, D. (2011). Penalized functional regression. \emph{Journal of Computational and Graphical Statistics}, to appear.

Goldsmith, J., Crainiceanu, C., Caffo, B., and Reich, D. (2010). Longitudinal penalized functional regression.  Available at \url{http://www.bepress.com/jhubiostat/paper216}

Reiss, P. T., Huang, L., and Mennes, M. (2010).  Fast function-on-scalar regression with penalized basis expansions.  \emph{International Journal of Biostatistics}, 6(1), article 28.  Available at \url{http://works.bepress.com/phil_reiss/16/}

Reiss, P. T., and Ogden, R. T. (2007).  Functional principal component regression and functional partial least squares.  \emph{Journal of the American Statistical Association}, 102, 984--996.

}
\keyword{ package }
\examples{
}
