% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.fosr.vs.R
\name{plot.fosr.vs}
\alias{plot.fosr.vs}
\title{Plot for Function-on Scalar Regression with variable selection}
\usage{
\method{plot}{fosr.vs}(x, ...)
}
\arguments{
\item{x}{an object of class "\code{\link{fosr.vs}}".}

\item{...}{additional arguments.}
}
\value{
a figure of estimated coefficient functions.
}
\description{
Given a "\code{\link{fosr.vs}}" object, produces a figure of estimated coefficient functions.
}
\examples{
\dontrun{
I = 100
p = 20
D = 50
grid = seq(0, 1, length = D)

beta.true = matrix(0, p, D)
beta.true[1,] = sin(2*grid*pi)
beta.true[2,] = cos(2*grid*pi)
beta.true[3,] = 2

psi.true = matrix(NA, 2, D)
psi.true[1,] = sin(4*grid*pi)
psi.true[2,] = cos(4*grid*pi)
lambda = c(3,1)

set.seed(100)

X = matrix(rnorm(I*p), I, p)
C = cbind(rnorm(I, mean = 0, sd = lambda[1]), rnorm(I, mean = 0, sd = lambda[2]))

fixef = X\%*\%beta.true
pcaef = C \%*\% psi.true
error = matrix(rnorm(I*D), I, D)

Yi.true = fixef
Yi.pca = fixef + pcaef
Yi.obs = fixef + pcaef + error

data = as.data.frame(X)
data$Y = Yi.obs
fit.mcp = fosr.vs(Y~., data = data[1:80,], method="grMCP")
plot(fit.mcp)
}
}
\author{
Yakuan Chen \email{yc2641@cumc.columbia.edu}
}
\seealso{
\code{\link{fosr.vs}}
}

