% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refitME_package.R
\name{refitME}
\alias{refitME}
\title{A wrapper function for correcting measurement error in predictor variables via the MCEM algorithm}
\source{
See \url{https://github.com/JakubStats/refitME} for an RMarkdown tutorial with examples.
}
\usage{
refitME(mod, sigma.sq.u, B = 50, epsilon = 1e-05, silent = FALSE, ...)
}
\arguments{
\item{mod}{: any (S3 class) fitted object that responds to the generic functions \code{family}, \code{model.frame}, \code{update} and \code{predict}, and accepts weighted observations via \code{weights}. The \code{mod} argument specifies the naive fitted model. Make sure the first \eqn{p} input predictor variables in the naive model are the selected error-contaminated predictors variables. Also, the \code{mod} argument allows \code{vlgm/vgam} (S4 class) model objects when using the \code{posbinomial} family -- this is a specific function developed for fitting closed population capture--recapture models, see \code{\link{MCEMfit_CR}}.}

\item{sigma.sq.u}{: measurement error (ME) variance. A scalar if there is only one error-contaminated predictor variable, otherwise this must be stored as a vector (of known ME variances) or a matrix if the ME covariance matrix is known.}

\item{B}{: the number of Monte Carlo replication values (default is set 50).}

\item{epsilon}{: convergence threshold (default is set to 0.00001).}

\item{silent}{: if \code{TRUE}, the convergence message (which tells the user if the model has converged and reports the number of iterations required) is suppressed (default is set to \code{FALSE}).}

\item{...}{: further arguments passed through to the function that was used to fit \code{mod}, that will be used in refitting. These need only be specified if making changes to the arguments as compared to the original call that produced \code{mod}.}
}
\value{
\code{refitME} returns the naive fitted model object where coefficient estimates, the covariance matrix, fitted values, the log-likelihood, and residuals have been replaced with the final MCEM model fit. Standard errors are included and returned, if \code{mod} is a class of object accepted by the \pkg{sandwich} package (such as \code{glm}, \code{gam}, \code{survreg} and many more). The effective sample size (which diagnose how closely the proposal distribution matches the posterior, see equation (2) of Stoklosa, Hwang and Warton) have also been included as outputs.
}
\description{
Function that extracts the fitted (naive) model object and wraps the MCEM algorithm to correct for measurement error/error-in-variables in predictors.
}
\examples{
# A GLM example I - binary response data.

library(refitME)

data(Framinghamdata)

glm_naiv <- glm(Y ~ w1 + z1 + z2 + z3, x = TRUE, family = binomial, data = Framinghamdata)

# The error-contaminated predictor variable in this example is systolic blood pressure (w1).

sigma.sq.u <- 0.01259/2 # ME variance, as obtained from Carroll et al. (2006) monograph.

B <- 50  # The number of Monte Carlo replication values.

glm_MCEM <- refitME(glm_naiv, sigma.sq.u, B)

}
\references{
Carroll, R. J., Ruppert, D., Stefanski, L. A., and Crainiceanu, C. M. (2006). \emph{Measurement Error in Nonlinear Models: A Modern Perspective.} 2nd Ed. London: Chapman & Hall/CRC.

Stoklosa, J., Hwang, W-H., and Warton, D.I. \pkg{refitME}: Measurement Error Modelling using Monte Carlo Expectation Maximization in \proglang{R}.
}
\seealso{
\code{\link{MCEMfit_glm}}, \code{\link{MCEMfit_gam}} and \code{\link{MCEMfit_gen}}
}
\author{
Jakub Stoklosa, Wen-Han Hwang and David I. Warton.
}
