% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref.summary.R
\name{ref.summary}
\alias{ref.summary}
\title{Parameter Summaries for MCMC Analysis}
\usage{
ref.summary(MCMCchain, tauc.MCMC, sigma2.MCMC, beta.MCMC, phi.MCMC,
  accept.phi, accept.sigma2, accept.tauc, iters = 10000, burnin = 5000)
}
\arguments{
\item{MCMCchain}{Matrix of MCMC chains for the ICAR model parameters.}

\item{tauc.MCMC}{MCMC chains for the spatial dependence parameter.}

\item{sigma2.MCMC}{MCMC chains for the variance of the unstructured random effects.}

\item{beta.MCMC}{MCMC chains for the fixed effect regression coefficients.}

\item{phi.MCMC}{MCMC chains for the spatial random effects.}

\item{accept.phi}{Final acceptance number for spatial random effects.}

\item{accept.sigma2}{Final acceptance number for variance of the unstructured random effects.}

\item{accept.tauc}{Final acceptance number for the spatial dependence parameter.}

\item{iters}{Number of MCMC iterations in \code{MCMCchain}.}

\item{burnin}{Number of MCMC iterations discarded as burn-in for \code{MCMCchain}.}
}
\value{
Parameter summaries
    \item{beta.median}{Posterior medians of the fixed effect regression coefficients.}
    \item{beta.hpd}{Highest Posterior Density intervals for the fixed effect regression coefficients.}
    \item{tauc.median}{Posterior median of the spatial dependence parameter.}
    \item{tauc.hpd}{Highest Posterior Density interval for the spatial dependence parameter.}
    \item{sigma2.median}{Posterior median of the unstructured random effects variance.}
    \item{sigma2.hpd}{Highest Posterior Density interval for the unstructured random effects variance.}
    \item{tauc.accept}{Final acceptance rate for the spatial dependence parameter.}
    \item{sigma2.accept}{Final acceptance rate for the unstructured random effects variance.}
}
\description{
Takes a matrix of MCMC chains, iterations, and acceptance values
to return posterior summaries of the parameters, including posterior medians, intervals,
and acceptance rates.
}
\examples{
## Refer to the vignette attached to the package.
}
\author{
Erica M. Porter, Matthew J. Keefe, Christopher T. Franck, and Marco A.R. Ferreira
}
