% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridUncertainty_functions.R
\name{gridUncertaintyBase}
\alias{gridUncertaintyBase}
\title{Base function to compute AOO with grid uncertainty systematically}
\usage{
gridUncertaintyBase(input.data, grid.size, splits,
  min.percent.rule = FALSE, percent = 1, restriction = FALSE,
  min.grids.shift)
}
\arguments{
\item{input.data}{Object of an ecosystem or species distribution. Accepts either
raster or spatial points formats. Please use a CRS with units measured in
metres.}

\item{grid.size}{A number specifying the width of the desired grid square (in
same units as your coordinate reference system)}

\item{splits}{Specifies the number of ways to split the grid in ONE axis.}

\item{min.percent.rule}{Logical. If \code{TRUE}, a minimum area threshold
must be passed before a grid is counted as an AOO grid.}

\item{percent}{Numeric. The minimum percent to be applied as a threshold for
the \code{min.percent.rule}.}

\item{restriction}{Logical. If \code{TRUE}, allows user to specify areas to
focus where grid search is done. Used in gridUncertaintyRestricted.}

\item{min.grids.shift}{Dataframe object with two columns (x.shift and
y.shift) specifying the coordinates to restrict the AOO grid placement.}
}
\value{
List containing the following:
\itemize{
 \item Vector of length split*split of calculated AOO for each shifted grid
 \item Data frame of summary statistics for the results
 create the AOO grid(s) which return the smallest AOO
 \item Data frame of the shift(s) required to create the AOO grid(s) with the
 smallest AOO
}
}
\description{
\code{gridUncertaintyBase} helps determine the minimum number of area of
occupancy (AOO) grid cells occupied by a species or ecosystem. It varies the
location of the AOO grid by shifting in systematically in both x- and y-
axes, adding a small amount of random movement (five percent of the
\code{grid.size}) at each point. It then returns summary statistics for the
range of AOOs calculated, and the RasterLayer(s) containing the grids with
the minimum AOO. It is the base function which is used by
\code{gridUncertainty}, \code{gridUncertaintySimulation}, and
\code{gridUncertaintyRestricted}
}
\seealso{
\code{\link{createGrid}} \code{\link{getAOOSilent}}

Other gridUncertainty functions: \code{\link{gridUncertaintyRandomManual}},
  \code{\link{gridUncertaintyRandom}},
  \code{\link{gridUncertaintyRestricted}},
  \code{\link{gridUncertaintySimulation}},
  \code{\link{gridUncertainty}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
\concept{gridUncertainty functions}
