% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R, R/group_percent.R
\name{group_frac}
\alias{group_frac}
\alias{redist.group.percent}
\title{Calculate Group Proportion by District}
\usage{
group_frac(
  map,
  group_pop,
  total_pop = map[[attr(map, "pop_col")]],
  .data = cur_plans()
)

redist.group.percent(plans, group_pop, total_pop, ncores = 1)
}
\arguments{
\item{map}{a \code{\link{redist_map}} object}

\item{group_pop}{A numeric vector with the population of the group for every precinct.}

\item{total_pop}{A numeric vector with the population for every precinct.}

\item{.data}{a \code{\link{redist_plans}} object}

\item{plans}{A matrix with one row
for each precinct and one column for each map. Required.}

\item{ncores}{Number of cores to use for parallel computing. Default is 1.}
}
\value{
matrix with percent for each district
}
\description{
\code{redist.group.percent} computes the proportion that a group makes up in
each district across a matrix of maps.
}
\examples{
data(fl25)
data(fl25_enum)

cd <- fl25_enum$plans[, fl25_enum$pop_dev <= 0.05]

redist.group.percent(plans = cd,
    group_pop = fl25$BlackPop,
    total_pop = fl25$TotPop)

}
\concept{analyze}
