% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_mcmc.R
\name{redist.flip}
\alias{redist.flip}
\title{(Deprecated) Flip MCMC Redistricting Simulator}
\usage{
redist.flip(
  adj,
  total_pop,
  nsims,
  ndists = NULL,
  init_plan = NULL,
  constraints = redist_constr(),
  loopscompleted = 0,
  nloop = 1,
  warmup = 0,
  nthin = 1,
  eprob = 0.05,
  lambda = 0,
  pop_tol = NULL,
  temper = FALSE,
  betaseq = "powerlaw",
  betaseqlength = 10,
  betaweights = NULL,
  adjswaps = TRUE,
  rngseed = NULL,
  maxiterrsg = 5000,
  adapt_lambda = FALSE,
  adapt_eprob = FALSE,
  exact_mh = FALSE,
  savename = NULL,
  verbose = TRUE
)
}
\arguments{
\item{adj}{adjacency matrix, list, or object of class
"SpatialPolygonsDataFrame."}

\item{total_pop}{A vector containing the populations of each geographic
unit}

\item{nsims}{The number of simulations run before a save point.}

\item{ndists}{The number of congressional districts. The default is
\code{NULL}.}

\item{init_plan}{A vector containing the congressional district labels
of each geographic unit. If not provided, random and contiguous congressional
district assignments will be generated using \code{redist_smc}. To use the old
behavior of generating with \code{redist.rsg}, provide init_plan = 'rsg'.}

\item{constraints}{A `redist_constr` list.}

\item{loopscompleted}{Number of save points reached by the
algorithm. The default is \code{0}.}

\item{nloop}{The total number of save points for the algorithm. The
default is \code{1}. Note that the total number of simulations run
will be \code{nsims} * \code{nloop}. \code{savename} must be non-null.}

\item{warmup}{The number of warmup samples to discard. The default is 0.}

\item{nthin}{The amount by which to thin the Markov Chain. The
default is \code{1}.}

\item{eprob}{The probability of keeping an edge connected. The
default is \code{0.05}.}

\item{lambda}{The parameter determining the number of swaps to attempt
each iteration of the algorithm. The number of swaps each iteration is
equal to Pois(\code{lambda}) + 1. The default is \code{0}.}

\item{pop_tol}{The strength of the hard population
constraint. \code{pop_tol} = 0.05 means that any proposed swap that
brings a district more than 5\% away from population parity will be
rejected. The default is \code{NULL}.}

\item{temper}{Whether to use simulated tempering algorithm. Default is FALSE.}

\item{betaseq}{Sequence of beta values for tempering. The default is
\code{powerlaw} (see Fifield et. al (2015) for details).}

\item{betaseqlength}{Length of beta sequence desired for
tempering. The default is \code{10}.}

\item{betaweights}{Sequence of weights for different values of
beta. Allows the user to upweight certain values of beta over
others. The default is \code{NULL} (equal weighting).}

\item{adjswaps}{Flag to restrict swaps of beta so that only
values adjacent to current constraint are proposed. The default is
\code{TRUE}.}

\item{rngseed}{Allows the user to set the seed for the
simulations. Default is \code{NULL}.}

\item{maxiterrsg}{Maximum number of iterations for random seed-and-grow
algorithm to generate starting values. Default is 5000.}

\item{adapt_lambda}{Whether to adaptively tune the lambda parameter so that the Metropolis-Hastings
acceptance probability falls between 20\% and 40\%. Default is FALSE.}

\item{adapt_eprob}{Whether to adaptively tune the edgecut probability parameter so that the
Metropolis-Hastings acceptance probability falls between 20\% and 40\%. Default is
FALSE.}

\item{exact_mh}{Whether to use the approximate (0) or exact (1)
Metropolis-Hastings ratio calculation for accept-reject rule. Default is FALSE.}

\item{savename}{Filename to save simulations. Default is \code{NULL}.}

\item{verbose}{Whether to print initialization statement.
Default is \code{TRUE}.}
}
\value{
\code{redist.mcmc} returns an object of class "redist". The object
\code{redist} is a list that contains the following components (the
inclusion of some components is dependent on whether tempering
techniques are used):
\item{plans}{Matrix of congressional district assignments generated by the
algorithm. Each row corresponds to a geographic unit, and each column
corresponds to a simulation.}
\item{distance_parity}{Vector containing the maximum distance from parity for
a particular simulated redistricting plan.}
\item{mhdecisions}{A vector specifying whether a proposed redistricting plan
was accepted (1) or rejected (0) in a given iteration.}
\item{mhprob}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm.}
\item{pparam}{A vector containing the draw of the \code{p} parameter for each
simulation, which dictates the number of swaps attempted.}
\item{constraint_pop}{A vector containing the value of the population
constraint for each accepted redistricting plan.}
\item{constraint_compact}{A vector containing the value of the compactness
constraint for each accepted redistricting plan.}
\item{constraint_segregation}{A vector containing the value of the
segregation constraint for each accepted redistricting plan.}
\item{constraint_vra}{A vector containing the value of the
vra constraint for each accepted redistricting plan.}
\item{constraint_similar}{A vector containing the value of the similarity
constraint for each accepted redistricting plan.}
\item{constraint_partisan}{A vector containing the value of the
partisan constraint for each accepted redistricting plan.}
\item{constraint_minority}{A vector containing the value of the
minority constraint for each accepted redistricting plan.}
\item{constraint_hinge}{A vector containing the value of the
hinge constraint for each accepted redistricting plan.}
\item{constraint_qps}{A vector containing the value of the
QPS constraint for each accepted redistricting plan.}
\item{beta_sequence}{A vector containing the value of beta for each iteration
of the algorithm. Returned when tempering is being used.}
\item{mhdecisions_beta}{A vector specifying whether a proposed beta value was
accepted (1) or rejected (0) in a given iteration of the algorithm. Returned
when tempering is being used.}
\item{mhprob_beta}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm. Returned when tempering
is being used.}
}
\description{
\code{redist.mcmc} is used to simulate Congressional redistricting
plans using Markov Chain Monte Carlo methods.
}
\details{
This function allows users to simulate redistricting plans
using Markov Chain Monte Carlo methods. Several constraints
corresponding to substantive requirements in the redistricting process
are implemented, including population parity and geographic
compactness. In addition, the function includes multiple-swap and
simulated tempering functionality to improve the mixing of the Markov
Chain.
}
\examples{
\donttest{
data(fl25)
data(fl25_enum)
data(fl25_adj)

## Code to run the simulations in Figure 4 in Fifield, Higgins, Imai and Tarr (2015)

## Get an initial partition
init_plan <- fl25_enum$plans[, 5118]

## Run the algorithm
alg_253 <- redist.flip(adj = fl25_adj, total_pop = fl25$pop,
    init_plan = init_plan, nsims = 10000)

## You can also let it find a plan on its own!
sims <- redist.flip(adj = fl25_adj, total_pop = fl25$pop,
    ndists = 3, nsims = 10000)
}

}
\references{
Fifield, Benjamin, Michael Higgins, Kosuke Imai and Alexander
Tarr. (2016) "A New Automated Redistricting Simulator Using Markov Chain Monte
Carlo." Working Paper. Available at
\url{http://imai.princeton.edu/research/files/redist.pdf}.
}
\concept{simulate}
