% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_map.R
\name{redist_map}
\alias{redist_map}
\alias{as_redist_map}
\title{Create a \code{redist_map} object.}
\usage{
redist_map(
  ...,
  existing_plan = NULL,
  pop_tol = NULL,
  total_pop = c("pop", "population", "total_pop", "POP100"),
  ndists = NULL,
  pop_bounds = NULL,
  adj = NULL,
  adj_col = "adj",
  planarize = 3857
)

as_redist_map(x)
}
\arguments{
\item{...}{column elements to be bound into a \code{redist_map} object or a
single \code{list} or \code{data.frame}.  These will be passed on to the
\code{\link{tibble}} constructor.}

\item{existing_plan}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} the
existing district assignment. Must be numeric or convertable to numeric.}

\item{pop_tol}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} the population tolerance.
The percentage deviation from the average population will be constrained to
be no more than this number. If \code{existing_plan} is provided, defaults to
the parity of that plan; otherwise, defaults to 0.01.}

\item{total_pop}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} the vector
of precinct populations. Defaults to the \code{pop}, \code{population}, or
\code{total_pop} columns, if one exists.}

\item{ndists}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} the integer number of
districts to partition the map into. Must be specified if \code{existing_plan} is not supplied.}

\item{pop_bounds}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} more specific
population bounds, in the form of \code{c(lower, target, upper)}.}

\item{adj}{the adjacency graph for the object. Defaults to being computed
from the data if it is coercible to a shapefile.}

\item{adj_col}{the name of the adjacency graph column}

\item{planarize}{a number, indicating the CRS to project the shapefile to if
it is latitude-longitude based. Set to NULL or FALSE to avoid planarizing.}

\item{x}{an object to be coerced}
}
\value{
A redist_map object
}
\description{
Sets up a redistricting problem.
}
\details{
A \code{redist_map} object is a \code{\link{tibble}} which contains an
adjacency list and additional information about the number of districts and
population bounds.  It supports all of the \code{dplyr} generics, and will
adjust the adjacency list and attributes according to these functions; i.e.,
if we \code{filter} to a subset of units, the graph will change to subset to
these units, and the population bounds will adjust accordingly.  If an
existing map is also attached to the object, the number of districts will
also adjust.  Subsetting with \code{`[`} and \code{`[[`} does not recompute
graphs or attributes.

Other useful methods for \code{redist_map} objects:
\itemize{
\item \code{\link{merge_by}}
\item \code{\link{get_adj}}
\item \code{\link{plot.redist_map}}
}
}
\examples{
data(fl25)
d = redist_map(fl25, ndists=3, pop_tol=0.05, total_pop = pop)
dplyr::filter(d, pop >= 10e3)

}
\concept{prepare}
