% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reindex.R
\name{redist.reindex}
\alias{redist.reindex}
\title{Reorders district numbers}
\usage{
redist.reindex(plans, district_membership)
}
\arguments{
\item{plans}{A numeric vector (if only one map) or
matrix with one row for each precinct and one column for each map.}

\item{district_membership}{Deprecated, use plans. A numeric vector (if only one map) or
matrix with one row for each precinct and one column for each map.}
}
\value{
integer matrix
}
\description{
Ensures that for each column in the plans object, the first
district listed is 1, the second is 2, up to n districts. Assumes that all
columns have the same number of districts as the first.
}
\examples{
\dontrun{
cds <- matrix(c(rep(c(4L,5L,2L,1L,3L),5),
rep(c(5L,4L,3L,2L,1L),2), rep(c(4L,5L,2L,1L,3L),3)), nrow = 25)
redist.reorder(cds)
}
}
