% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assembleCodebook.R
\name{assembleCodebook}
\alias{assembleCodebook}
\alias{assembleCodebook.redcapConnection}
\alias{as.list.redcapCodebook}
\title{Assemble Codebook From the Data Dictionary}
\usage{
assembleCodebook(
  rcon,
  fields = NULL,
  forms = NULL,
  drop_fields = NULL,
  field_types = NULL,
  include_form_complete = TRUE,
  expand_check = FALSE,
  ...
)

\method{assembleCodebook}{redcapConnection}(
  rcon,
  fields = NULL,
  forms = NULL,
  drop_fields = NULL,
  field_types = NULL,
  include_form_complete = TRUE,
  expand_check = FALSE,
  ...
)

\method{as.list}{redcapCodebook}(x, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{fields}{\code{character} or \code{NULL}. When \code{character}, the code book will
be limited to the intersection of the fields designated by \code{fields}
and \code{forms}. When \code{NULL}, all fields are included.}

\item{forms}{\code{character} or \code{NULL}. When \code{character}, the code book will
be limited to the intersection of the fields designated by \code{fields}
and \code{forms}. When \code{NULL}, all forms are included.}

\item{drop_fields}{\code{character} or \code{NULL}. When given, fields named
will be removed from the code book.}

\item{field_types}{\code{character} or \code{NULL}. When given, only the field
types listed will be included in the code book. This will supercede
the intersection of \code{fields} and \code{forms}. Matching of field types is
performed against the values in the \code{field_type} column of the meta data.}

\item{include_form_complete}{\code{logical(1)}. When \code{TRUE}, the
\verb{[form name]_complete} fields will be included in the codebook.}

\item{expand_check}{\code{logical(1)}. When \code{FALSE}, the codebook for checkbox
fields will be similar to the codebook for dropdown and radio fields,
with one line per user-defined option. When \code{TRUE}, each checkbox option
will be represented in two fields, one each for 0 (Unchecked) and
1 (Checked).}

\item{...}{Arguments to pass to other methods}

\item{x}{A \code{redcapCodebook} object as returned by \code{assembleCodebook}.}
}
\value{
Returns a \code{redcapCodebook} object. This inherits the \code{data.frame} class
and has the columns
\itemize{
\item \code{field_name} - The name of the field.
\item \code{form} - The name of the form on which the field is located.
\item \code{field_type} - The field type.
\item \code{code} - For multiple choice fields, the coding for the option.
\item \code{label} - For multiple choice fields, the label for the option.
\item \code{min} - For date and numeric fields, the minimum value in the validation, if any.
\item \code{max} - For date and numeric fields, the maximum value in the validation, if any.
\item \code{branching_logic} - For fields with branching logic, the string denoting the logic applied.
\item \code{field_order} - The numeric order of the field in the data dictionary.
\item \code{form_order} - The numeric order of the form in the data dictionary.
}
}
\description{
This method enables the user to construct a code book similar
in style to the REDCap project codebook. The codebook is similar in
nature to the data dictionary, but multiple choice fields are represented
with one line per coding.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# codebook for the entire project
assembleCodebook(rcon)

# codebook for multiple choice fields
assembleCodebook(rcon, 
                 field_types = c("dropdown", "radio", "checkbox", 
                                 "yesno", "truefalse"))
}

}
\seealso{
\code{\link[=exportMetaData]{exportMetaData()}}
}
