% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importArms.R
\name{importArms}
\alias{importArms}
\alias{importArms.redcapApiConnection}
\title{Import Study Arm Names}
\usage{
importArms(rcon, arms_data, override = FALSE, ...)

\method{importArms}{redcapApiConnection}(
  rcon,
  arms_data,
  override = FALSE,
  ...,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by 
\code{redcapConnection}.}

\item{arms_data}{A \code{data.frame} with two columns.  The first column 
is an integer-like value with the name \code{arm_num}. The second is
a character value with the name \code{name}.}

\item{override}{\code{logical(1)}. When \code{TRUE}, the action is to 
delete all of the arms in the project and import the contents of 
\code{arms_data}.  The default setting is \code{FALSE}, which only
allows arms to be renamed or added.}

\item{...}{additional arguments to pass to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\value{
No value is returned.
}
\description{
Import Arms into a project or to rename existing Arms in a 
  project. You may use the parameter \code{override = TRUE} as a 'delete 
  all + import' action in order to erase all existing Arms in the 
  project while importing new Arms. Notice: Because of the 'override' 
  parameter's destructive nature, this method may only use 
  \code{override = TRUE} for projects in Development status.
}
\section{REDCap API Documentation}{

This method allows you to import Arms into a project or to rename 
existing Arms in a project. You may use the parameter override=1 as a 
'delete all + import' action in order to erase all existing Arms in the 
project while importing new Arms. Notice: Because of the 'override' 
parameter's destructive nature, this method may only use override=1 
for projects in Development status.

NOTE: This only works for longitudinal projects.
}

\section{REDCap Version}{

At least 8.1.17+ (and likely some earlier versions)
}

\references{
Please refer to your institution's API documentation.
}
