% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changedRecords.R
\name{changedRecords}
\alias{changedRecords}
\title{returns a list of record IDs changed (adds, updates, deletes)}
\usage{
changedRecords(rcon, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{...}{Arguments passed to \code{\link[=exportLogging]{exportLogging()}}}
}
\value{
Returns a list with the elements\tabular{ll}{
    \tab  \cr
   \code{updated} \tab character vector of updated record IDs \cr
   \code{deleted} \tab character vector of deleted record IDs \cr
   \code{created} \tab character vector of created record IDs \cr
}
}
\description{
This is a convenience function that scans logs and
returns record IDs of changed records.
}
\details{
Makes a call to \code{exportLogging} with passed arguments. Returns
filtered list or records IDs with update, delete or create events.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

# Changes in last 24 hours     
changedRecords(rcon, beginTime=as.POSIXct(Sys.time()-86400))
}

}
