% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bounce_rate}
\alias{bounce_rate}
\title{calculate the bounce rate within a session dataset}
\usage{
bounce_rate(sessions, decimal_places = 2)
}
\arguments{
\item{sessions}{a list of sessions, generated with \code{\link{sessionise}}}

\item{decimal_places}{the number of decimal places to round the output to - set to 2 by default.}
}
\value{
a single numeric value, representing the percentage of sessions that are bounces.
}
\description{
calculates the "bounce rate" within a set of sessions - the proportion of sessions
consisting only of a single event.
}
\examples{
#Calculate the bounce rate in the provided dataset.
#Load, convert timestamps to seconds, split
data("session_dataset")
session_dataset$timestamp <- to_seconds(x = session_dataset$timestamp, format = "\%Y\%m\%d\%H\%M\%S")
events_by_user <- split(session_dataset$timestamp, session_dataset$UUID)

#Sessionise and calculate bounce rate
sessions <- sessionise(events_by_user)
bounce_rate(sessions)
#[1]58
}
\seealso{
\code{\link{session_events}} for generaliseable event-level calculations, and
\code{link{event_time}} for performing operations on the time between events.
}

