% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wernerColor.R
\name{wernerColor}
\alias{wernerColor}
\title{Remap an image to Werner's nomenclature}
\usage{
wernerColor(recolorize_obj, which_img = "original", n_colors = 5)
}
\arguments{
\item{recolorize_obj}{A recolorize object as returned by
\code{\link{recolorize}}, \code{\link{recluster}}, or
\code{\link{imposeColors}}.}

\item{which_img}{Which image to recolor; one of either "original" or
"recolored".}

\item{n_colors}{Number of colors to list out in plotting, in order of
size. Ex: \code{n_colors = 5} will plot the 5 largest colors and their names.
All colors are returned as a normal recolorize object regardless of
\code{n_colors}; this only affects the plot.}
}
\value{
A \code{recolorize} object with an additional list element, \code{werner_names},
listing the Werner color names for each center.
}
\description{
Remaps a recolorize object to the colors in Werner's Nomenclature of Colors
by Patrick Syme (1821), one of the first attempts at an objective color
reference in western science, notably used by Charles Darwin.
}
\details{
See \url{https://www.c82.net/werner/} to check out the original colors.
}
\examples{


# get an initial fit:
corbetti <- system.file("extdata/corbetti.png", package = "recolorize")
recolored_corbetti <- recolorize(corbetti, plotting = FALSE)

# recolor original image
corbetti_werner <- wernerColor(recolored_corbetti,
                               which_img = "original",
                               n_colors = 6)

# we can simplify the colors and then do it again:
corbetti_recluster <- recluster(recolored_corbetti,
                                cutoff = 45,
                                plot_hclust = FALSE)
corbetti_werner <- wernerColor(corbetti_recluster,
                               which_img = "recolored")

}
