% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-package.R
\docType{package}
\name{recipes}
\alias{recipes-package}
\alias{recipes}
\title{recipes: A package for computing and preprocessing design matrices.}
\description{
The \code{recipes} package can be used to create design matrices for modeling
and to conduct preprocessing of variables. It is meant to be a more
extensive framework that R's formula method. Some differences between
simple formula methods and recipes are that
\enumerate{
\item Variables can have arbitrary roles in the analysis beyond predictors
and outcomes.
\item A recipe consists of one or more steps that define actions on the
variables.
\item Recipes can be defined sequentially using pipes as well as being
modifiable and extensible.
}
}
\section{Basic Functions}{

The three main functions are \code{\link[=recipe]{recipe()}}, \code{\link[=prep]{prep()}},
and \code{\link[=bake]{bake()}}.

\code{\link[=recipe]{recipe()}} defines the operations on the data and the associated
roles. Once the preprocessing steps are defined, any parameters are
estimated using \code{\link[=prep]{prep()}}. Once the data are ready for
transformation, the \code{\link[=bake]{bake()}} function applies the operations.
}

\section{Step Functions}{

These functions are used to add new actions to the recipe and have the
naming convention \code{"step_action"}. For example,
\code{\link[=step_center]{step_center()}} centers the data to have a zero mean and
\code{\link[=step_dummy]{step_dummy()}} is used to create dummy variables.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tidymodels/recipes}
  \item \url{https://recipes.tidymodels.org/}
  \item Report bugs at \url{https://github.com/tidymodels/recipes/issues}
}

}
\author{
\strong{Maintainer}: Max Kuhn \email{max@posit.co}

Authors:
\itemize{
  \item Hadley Wickham \email{hadley@posit.co}
  \item Emil Hvitfeldt \email{emil.hvitfeldt@posit.co}
}

Other contributors:
\itemize{
  \item Posit Software, PBC [copyright holder, funder]
}

}
\keyword{internal}
