% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/escape_special.R
\name{escape_special}
\alias{escape_special}
\title{Escape special characters}
\usage{
escape_special(x, escape_brace = TRUE)
}
\arguments{
\item{x}{A character vector.}

\item{escape_brace}{A logical value indicating if opening braces should be
escaped.  If using R's internal regex engine, you want this.  If using the
perl engine, you don't.}
}
\value{
A character vector, with regex meta-characters escaped.
}
\description{
Prefix the special characters with a blackslash to make them literal
characters.
}
\note{
Special characters inside character classes (except caret, hypen and
closing bracket in certain positions) do not need to be escaped. This
function makes no attempt to parse your regular expression and decide whether
or not the special character is inside a character class or not.  It simply
escapes every value.
}
\examples{
\dontrun{
escape_special("\\\\ ^ $ . | ? * + ( ) { } [ ]")
}
}

