% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdgeo.R
\name{ebirdgeo}
\alias{ebirdgeo}
\title{Sightings at location determined by latitude/longitude}
\usage{
ebirdgeo(species = NULL, lat = NULL, lng = NULL, dist = NULL,
  back = NULL, max = NULL, locale = NULL, provisional = FALSE,
  hotspot = FALSE, sleep = 0, key = NULL, ...)
}
\arguments{
\item{species}{Species code of the species of interest. Scientific names can be specified if wrapped around the 
\code{\link{species_code}} function. Defaults to NULL, so sightings for all species are returned.
See eBird taxonomy for more information:
http://ebird.org/content/ebird/about/ebird-taxonomy}

\item{lat}{Decimal latitude. value between -90.00 and 90.00, up to two
decimal places of precision. Defaults to latitude based on IP.}

\item{lng}{Decimal longitude. value between -180.00 and 180.00, up to
two decimal places of precision. Defaults to longitude based on IP.}

\item{dist}{Distance defining radius of interest from given lat/lng in
kilometers (between 0 and 50, defaults to 25)}

\item{back}{Number of days back to look for observations (between
1 and 30, defaults to 14).}

\item{max}{Maximum number of result rows to return in this request
(between 1 and 10000, defaults to all).}

\item{locale}{Language/locale of response (when translations are available).
See http://java.sun.com/javase/6/docs/api/java/util/Locale.html
(defaults to en_US).}

\item{provisional}{Should flagged records that have not been reviewed
be included? (defaults to FALSE).}

\item{hotspot}{Should results be limited to sightings at birding hotspots?
(defaults to FALSE).}

\item{sleep}{Time (in seconds) before function sends API call (defaults to
zero. Set to higher number if you are using this function in a loop with
many API calls).}

\item{key}{ebird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an 
environment variable called \code{EBIRD_KEY}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame containing the collected information:

"comName": species common name

"howMany": number of individuals observed, NA if only presence was noted

"lat": latitude of the location

"lng": longitude of the location

"locID": unique identifier for the location

"locName": location name

"locationPrivate": TRUE if location is not a birding hotspot

"obsDt": observation date formatted according to ISO 8601
   (e.g. 'YYYY-MM-DD', or 'YYYY-MM-DD hh:mm'). Hours and minutes are excluded
   if the observer did not report an observation time.

"obsReviewed": TRUE if observation has been reviewed, FALSE otherwise

"obsValid": TRUE if observation has been deemed valid by either the
   automatic filters or a regional viewer, FALSE otherwise

"sciName" species' scientific name
}
\description{
Returns the most recent sighting date and specific location for the requested
species of bird reported within the number of days specified and reported in 
the specified area.
}
\examples{
\dontrun{
ebirdgeo('amegfi', 42, -76) # American Goldfinch
ebirdgeo(species_code('spinus tristis'), 42, -76) # same as above
ebirdgeo(lat=42, lng=-76, max=10, provisional=TRUE, hotspot=TRUE)
ebirdgeo(species_code('Anas platyrhynchos'), 39, -121, max=5)
library('httr')
ebirdgeo(species_code('Anas platyrhynchos'), 39, -121, max=5, config=verbose())
ebirdgeo(species_code('Anas platyrhynchos'), 39, -121, max=5, config=progress())
# ebirdgeo(species_code('Anas platyrhynchos'), 39, -121, max=5, config=timeout(0.1))
}
}
\references{
\url{http://ebird.org/}
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu},
   Sebastian Pardo \email{sebpardo@gmail.com}
}
