% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_centroids.R
\name{transfer_centroids}
\alias{transfer_centroids}
\title{Transfer centroids from one data frame to another}
\usage{
transfer_centroids(to_data, from_data, cols, group_cols = NULL)
}
\arguments{
\item{to_data}{\code{data.frame}.

Existing \code{`dplyr`} groups are ignored. Specify in \code{`group_cols`} instead.}

\item{from_data}{\code{data.frame} with the same columns (and groupings) as \code{`to_data`}.

Existing \code{`dplyr`} groups are ignored. Specify in \code{`group_cols`} instead.}

\item{cols}{Names of numeric columns to transfer centroids to.
Must exist in both \code{`to_data`} and \code{`from_data`}.}

\item{group_cols}{Names of grouping columns.}
}
\value{
The \code{`to_data`} \code{data.frame} (\code{tibble}) with the
centroids from the \code{`from_data`} \code{data.frame}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Given two \code{data.frames} with the same columns (and groupings),
transfer the centroids from one to the other.

This is commonly used to restore the centroids after transforming the columns.
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create a data frame
df <- data.frame(
  "x" = runif(20),
  "y" = runif(20),
  "g" = rep(1:4, each = 5)
)

# Create another data frame with different x and y values
df2 <- df
df2$x <- runif(20)
df2$y <- runif(20)

# Check centroids before transfer

df \%>\%
  dplyr::group_by(g) \%>\%
  dplyr::summarize_all(mean)

df2 \%>\%
  dplyr::group_by(g) \%>\%
  dplyr::summarize_all(mean)

# Now let's transfer the centroids from df to df2

df3 <- transfer_centroids(
  to_data = df2,
  from_data = df,
  cols = c("x", "y"),
  group_cols = "g"
)

# Check that the transfer gave us the same centroids as df
df3 \%>\%
  dplyr::group_by(g) \%>\%
  dplyr::summarize_all(mean)
}
\seealso{
Other clustering functions: 
\code{\link{cluster_groups}()},
\code{\link{generate_clusters}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{clustering functions}
