library(rearrr)
context("calculate_distances_()")


test_that("calculate_distances_() works in 2d", {
  xpectr::set_test_seed(42)

  dim_vectors <- list("a" = runif(10), "b" = runif(10))

  # Manual calc to check

  as <- dim_vectors[["a"]]
  bs <- dim_vectors[["b"]]
  man_dists <- plyr::llply(seq_len(10), function(i){
    sqrt( (as[[i]] - 0.3)^2 + (bs[[i]] - 0.5)^2)
  }) %>% unlist(recursive = T)

  calc_dists <- calculate_distances_(dim_vectors = dim_vectors, to = c(0.3, 0.5))

  expect_equal(man_dists, calc_dists)

  ## Testing 'calc_dists'                                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(calc_dists),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    calc_dists,
    type = "double")
  # Testing values
  expect_equal(
    calc_dists,
    c(0.61626, 0.6737, 0.43489, 0.58411, 0.34382, 0.49154, 0.64754,
      0.41671, 0.35787, 0.40953),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(calc_dists),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(calc_dists),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(calc_dists)),
    10L)
  ## Finished testing 'calc_dists'                                          ####

})




