% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_length.R
\name{vector_length}
\alias{vector_length}
\title{Calculate vector length(s)}
\usage{
vector_length(
  data,
  cols = NULL,
  by_row = is.data.frame(data),
  len_col_name = ".vec_len",
  overwrite = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{cols}{Names of columns in \code{`data`} to measure vector length of.}

\item{by_row}{Whether to measure length of row vectors instead of column vectors. (Logical)

Note: Disable when \code{`data`} is a \code{vector}.}

\item{len_col_name}{Name of new column with the row vector lengths when
\code{`data`} is a \code{data.frame} and \code{`by_row`} is \code{TRUE}.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}
}
\value{
Vector length(s).

When \code{`data`} is a \code{vector}: \code{scalar}

When \code{`data`} is a \code{data.frame} and \code{`by_row`} is \code{TRUE}:
\code{`data`} with an extra column with row vector lengths.

When \code{`data`} is a \code{data.frame} and \code{`by_row`} is \code{FALSE}:
A \code{data.frame} with the summarized column vector lengths.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Calculates vector lengths/magnitudes \emph{row-} or \emph{column-wise} with
\deqn{sqrt(sum(x^2))}
Where \eqn{x} is the \code{vector} to get the length/magnitude of.

Should not be confused with \code{\link[base:length]{length()}}, which counts the elements.
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create a data frame
df <- data.frame(
  "x" = runif(20),
  "y" = runif(20),
  "g" = rep(1:4, each = 5)
)

# Measure row-wise
vector_length(df, cols = c("x", "y"), by_row = TRUE)

# Measure column-wise
vector_length(df, cols = c("x", "y"), by_row = FALSE)

# By groups in 'g'
df \%>\%
  dplyr::group_by(g) \%>\%
  vector_length(cols = c("x", "y"), by_row = FALSE)

# Measure vector length of a vector
vector_length(c(1:10))
}
\seealso{
Other measuring functions: 
\code{\link{angle}()},
\code{\link{distance}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{measuring functions}
