% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R.R
\name{R}
\alias{R}
\title{Create a Result Descriptor by Recording Effects of an Expression Evaluation}
\usage{
R(expr, ...)
}
\arguments{
\item{expr}{a formal argument to be evaluated}

\item{...}{further arguments to be passed to \code{\link{P}}}
}
\value{
A list of class \code{realtest_descriptor},
see \code{\link{P}}, which this function calls.
The additional named component \code{expr} gives the
expression used to generate the \code{value}.
}
\description{
Evaluates an expression and records its direct and indirect effects:
the resulting value as well as the information whether any errors,
warnings, or messages are generated and if anything on
\code{\link[base]{stdout}} or \code{\link[base]{stderr}} is printed.
}
\details{
There may be other side effects, such as changing the state of
the random number generator, modifying options or environment variables,
modifying the calling or global environment (e.g., creating new global
variables), attaching objects onto the search part (e.g., loading
package namespaces), or plotting, but these are not captured,
at least, not in the current version of the package.
}
\examples{
R(sum(1:10))
R(cat("a bit talkative, innit?"))
R(sqrt(c(-1, 0, 1, 2, 4)))
R(log("aaaargh"))

}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}

Related functions:
\code{\link{E}}, \code{\link{P}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
