% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_print.R
\name{print_data}
\alias{print_data}
\title{Print a table of ready4 model data collections}
\usage{
print_data(
  datasets_tb,
  by_dv_1L_lgl = FALSE,
  filter_cdns_ls = NULL,
  root_1L_chr = "https://dataverse.harvard.edu/dataverse/",
  scroll_height_1L_chr = character(0),
  scroll_width_1L_chr = character(0),
  toy_data_dv_1L_chr = "fakes",
  what_1L_chr = "all",
  ...
)
}
\arguments{
\item{datasets_tb}{Datasets (a tibble)}

\item{by_dv_1L_lgl}{By dataverse (a logical vector of length one), Default: FALSE}

\item{filter_cdns_ls}{Filter conditions (a list), Default: NULL}

\item{root_1L_chr}{Root (a character vector of length one), Default: 'https://dataverse.harvard.edu/dataverse/'}

\item{scroll_height_1L_chr}{Scroll height (a character vector of length one), Default: character(0)}

\item{scroll_width_1L_chr}{Scroll width (a character vector of length one), Default: character(0)}

\item{toy_data_dv_1L_chr}{Toy data dataverse (a character vector of length one), Default: 'fakes'}

\item{what_1L_chr}{What (a character vector of length one), Default: 'all'}

\item{...}{Additional arguments}
}
\value{
Datasets (a kable)
}
\description{
make_programs_tbl() scrapes the GitHub organisation and Zenodo community associated specified for a ready4 model implementation to create a tabular summary of programs and sub-routines associated with that implementation.
}
\examples{
datasets_tb <- get_datasets_tb("ready4-dev/ready4")
print_data(datasets_tb, by_dv_1L_lgl = TRUE)
print_data(datasets_tb, what_1L_chr = "real")
print_data(datasets_tb, what_1L_chr = "fakes")

}
