% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{getLocus}
\alias{getLocus}
\alias{getLocus.genalex}
\title{Return genotype data for specified loci}
\usage{
\method{getLocus}{genalex}(x, locus, pop = NULL, ...)
}
\arguments{
\item{x}{An annotated data frame of class \code{'genalex'}}

\item{locus}{The names of one or more loci found in \code{x}}

\item{pop}{If supplied, return only data for samples from the specified
populations}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
An object of class \code{'data.frame'} containing genotype data
from \code{x} for loci specified in \code{code}, optionally restricted
to samples from populations specified in \code{pop}.
}
\description{
Return genotype data for specified loci in an object of class
\code{'data.frame'}, optionally restricted to samples from specific
populations.
}
\examples{
data(Qagr_pericarp_genotypes)
nm <- attr(Qagr_pericarp_genotypes, "locus.names")
# get the first locus
loc1 <- getLocus(Qagr_pericarp_genotypes, nm[1])
# get the second locus of the second population
po <- attr(Qagr_pericarp_genotypes, "pop.labels")
loc2.pop2 <- getLocus(Qagr_pericarp_genotypes, nm[2], po[2])
}
\author{
Douglas G. Scofield
}

