% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{parseActivityBin}
\alias{parseActivityBin}
\title{Parse activity samples from a NHANES-GT3X file}
\usage{
parseActivityBin(
  filename,
  max_samples,
  scale_factor,
  sample_rate,
  verbose = FALSE,
  debug = FALSE
)
}
\arguments{
\item{filename}{path to a activity.bin file inside the unzipped gt3x
folder, which contains the activity samples}

\item{max_samples}{Maximum number of rows to parse.
The returned matrix will always contain this number of rows, having zeroes if
not data is found.}

\item{scale_factor}{Scale factor for the activity samples.}

\item{sample_rate}{sampling rate for activity samples.}

\item{verbose}{Print the parameters from the activity.bin file and other messages?}

\item{debug}{Print information for every activity second}
}
\value{
Returns a matrix with max_samples rows and 3 columns, where the first 3
columns are the acceleration samples and
the last column is timestamps in seconds (including hundredth of seconds)
starting from 00:00:00 1970-01-01 UTC (UNIX time)
}
\description{
Parse activity samples from a NHANES-GT3X file
}
