% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{midnight}
\alias{midnight}
\title{Theme midnight}
\usage{
midnight(
  font_family = "Tahoma",
  font_size = 15,
  font_color = "#727272",
  header_font_family = "Tahoma",
  header_font_size = 15,
  header_font_color = "#666666",
  cell_padding = 6
)
}
\arguments{
\item{font_family}{Font family for the text within the table.
Default is Tahoma.}

\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #727272.}

\item{header_font_family}{Font family for the header text.
Default is Tahoma.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is #666666.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
midnight table theme
}
\examples{
data <- iris[10:29, ]

## Standard midnight theme
reactable(data,
          theme = midnight())

## Cerulean theme with additional options applied
reactable(data,
          theme = midnight(font_size = 12, font_color = "grey", cell_padding = 3))

}
