% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icon_assign.R
\name{icon_assign}
\alias{icon_assign}
\title{Assign icons to cells in a column}
\usage{
icon_assign(
  data,
  icon = "circle",
  fill_color = "#1e90ff",
  empty_color = "lightgrey",
  fill_opacity = 1,
  empty_opacity = 1,
  icon_size = 16,
  buckets = NULL,
  number_fmt = NULL,
  seq_by = 1,
  show_values = "none"
)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{icon}{A single icon from the Font Awesome library (via shiny).
Default icon is a circle.}

\item{fill_color}{A single color for the filled icons.
Default color is #1e90ff.}

\item{empty_color}{A single color for the empty icons.
Default color is lightgrey.}

\item{fill_opacity}{A value between 0 and 1 that adjusts the opacity in fill_color.
A value of 0 is fully transparent, a value of 1 is fully opaque.
Default is 1.}

\item{empty_opacity}{A value between 0 and 1 that adjusts the opacity in empty_color.
A value of 0 is fully transparent, a value of 1 is fully opaque.
Default is 1.}

\item{icon_size}{A value representing the size of the icon in px.
Default is 16.}

\item{buckets}{Optionally divide values in a column into buckets by providing a numeric value.
Icons are then assigned by rank from lowest to highest.
Default is set to NULL.}

\item{number_fmt}{Optionally format numbers using formats from the scales package.
Default is set to NULL.}

\item{seq_by}{A numerical input that determines what number each icon represents.
Ex. instead of displaying 100 icons for the number 100, can set seq_by = 10 to show only 10 icons.
Default value is set to 1.}

\item{show_values}{Optionally display values next to icons.
Options are "left", "right", above", "below", or "none".
Default is none.}
}
\value{
a function that applies colored icons
    to a column of numeric values.
}
\description{
The `icon_assign()` function assigns icons from the Font Awesome library (via shiny) to each cell of a numeric column depending on the value in each row.
    By default, the number of icons assigned will be equal to the value in that cell. If the value is less than the max, it will receive empty icons.
    Both the icon shape, size, and color of the filled and empty icons can be modified through the parameters.
    Values can optionally be shown with the icons if desired.
    It should be placed within the cell argument in reactable::colDef.
}
\examples{
data <- iris[10:29, ]
## By default, icon_assign() assigns a cirlce icon for each value up to the maximum value.
## If a value is 5 and the maximum value in the column is 6,
## It will assign 5 blue icons and 1 grey icon.
reactable(data,
columns = list(
Sepal.Length = colDef(cell = icon_assign(data))))

## Assign colors to filled icons and empty icons
reactable(data,
columns = list(
Sepal.Length = colDef(cell = icon_assign(data,
fill_color = "red",
empty_color = "white"))))

## Assign any icon from the Font Awesome Library
reactable(data,
columns = list(
Sepal.Length = colDef(cell = icon_assign(data,
icon = "fan"))))

## Optionally divide values into buckets and assign icons based on rank.
reactable(data,
columns = list(
Sepal.Length = colDef(cell = icon_assign(data,
buckets = 3))))

## Optionally display values next to icons.
reactable(data,
columns = list(
Sepal.Length = colDef(cell = icon_assign(data,
show_values = "right"))))

}
