% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactable-server.R
\name{reactable-extras-server}
\alias{reactable-extras-server}
\alias{reactable_extras_ui}
\alias{reactable_extras_server}
\title{Create reactable UI with server-side processing}
\usage{
reactable_extras_ui(id, width = "auto", height = "auto")

reactable_extras_server(id, data, total_pages = 4, sortable = TRUE, ...)
}
\arguments{
\item{id}{element id}

\item{width, height}{CSS unit (\code{"100\%"}, \code{"400px"}, or \code{"auto"}), numeric for number of pixels}

\item{data}{passed to \code{\link[reactable:reactable]{reactable::reactable()}}}

\item{total_pages}{number of pages}

\item{sortable}{allow sorting by columns}

\item{...}{other arguments to be passed to \code{\link[reactable:reactable]{reactable::reactable()}}}
}
\value{
\code{reactable_extras_ui()} returns a custom UI for a server-side processed reactable
}
\description{
Create reactable UI with server-side processing
}
\details{
Arguments passed to \code{\link[reactable:reactable]{reactable::reactable()}} must not contain \code{pagination} or \code{showPagination}.
These are set to \code{FALSE}. Pagination will be handled on the server-side.
}
\examples{
if (interactive()) {
  library(shiny)
  library(reactable)
  library(reactable.extras)

  shinyApp(
    reactable_extras_ui("big_data"),
    function(input, output, server) {
      reactable_extras_server(
        "big_data",
        data = mtcars,
        columns = list(
          mpg = reactable::colDef(name = "Miles per Gallon"),
          cyl = reactable::colDef(name = "Cylinders"),
          disp = reactable::colDef(name = "Displacement")
        ),
        rows_per_page = 7
      )
    }
  )
}
}
