% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotEvents}
\alias{plotEvents}
\title{Produce Event Plots}
\usage{
plotEvents(formula, data, result = c("increasing", "decreasing", "asis"),
  control = list(), ...)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a "~" operator,
and the predictors on the right.
The response must be a recurrent event survival object as returned by function \code{Recur()}.}

\item{data}{an optional data frame in which to interpret the variables occurring in the "\code{formula}".}

\item{result}{an optional character string specifying whether the event plot is sorted by the subjects' terminal time. The available options are
\describe{
  \item{\code{increasing}}{sort the terminal time from in increasing order (default). This places longer terminal times on top. }
  \item{\code{decreasing}}{sort the terminal time from in decreasing order (default). This places shorter terminal times on top. }
  \item{\code{asis}}{present the as is, without sorting.}
}}

\item{control}{a list of control parameters.}

\item{...}{graphical parameters to be passed to methods.
These include \code{xlab}, \code{ylab}, \code{main}, and more. See \bold{Details}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the event plot for an \code{Recur} object.
The usage of the function is similar to that of \code{plot.Recur} but with more flexible options.
}
\details{
The argument \code{control} consists of options with argument defaults to a
list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Subject".}
  \item{main}{customizable title, default value is "Recurrent event plot".}
  \item{terminal.name}{customizable label for terminal event, default value is "Terminal event".}
  \item{recurrent.name}{customizable legend title for recurrent event, default value is "Recurrent events".}
  \item{recurrent.types}{customizable label for recurrent event type, default value is \code{NULL}.}
  \item{alpha}{between 0 and 1, controls the transparency of points.}
}
The \code{xlab}, \code{ylab} and \code{main} parameters can also be passed down without specifying a \code{control} list. See \bold{Examples}.
}
\examples{
data(simDat)
plotEvents(Recur(Time, id, event, status) ~ 1, data = simDat)
plotEvents(Recur(Time, id, event, status) ~ 1, data = simDat,
           xlab = "Time in days", ylab = "Subjects arranged by terminal time")

## Separate plots by x1
plotEvents(Recur(Time, id, event, status) ~ x1, data = simDat)

## For multiple recurrent events
simDat$x3 <- ifelse(simDat$x2 < 0, "x2 < 0", "x2 > 0")
plotEvents(Recur(Time, id, event, status) ~ x1 + x3, data = simDat)
simDat$event <- simDat$event * sample(1:3, nrow(simDat), TRUE)
plotEvents(Recur(Time, id,  event, status) ~ x1, data = simDat)
plotEvents(Recur(Time, id,  event, status) ~ x1 + x3, data = simDat)
}
\seealso{
\code{\link{Recur}}, \code{\link{plot.Recur}}
}
\keyword{Plots}
