% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDWD.R
\name{dataDWD}
\alias{dataDWD}
\title{Download data from the DWD CDC FTP Server}
\usage{
dataDWD(
  url,
  base = dwdbase,
  joinbf = FALSE,
  dir = locdir(),
  force = FALSE,
  overwrite = !isFALSE(force),
  read = TRUE,
  dbin = TRUE,
  method = getOption("download.file.method"),
  dfargs = NULL,
  sleep = 0,
  progbar = !quiet,
  browse = FALSE,
  ntrunc = 2,
  file = NULL,
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{url}{Char (vector): complete file URL(s) (including base and filename.zip)
as returned by \code{\link[=selectDWD]{selectDWD()}}. Can be a vector with several FTP URLs.}

\item{base}{Single char: base URL that will be removed from output file names.
DEFAULT: \code{\link{dwdbase}}}

\item{joinbf}{Logical: paste \code{base} and \verb{file url} together?
Needed mostly for data at \code{\link{gridbase}}.
DEFAULT: FALSE (selectDWD returns complete URLs already)}

\item{dir}{Char: Writeable directory name where to save the downloaded file.
Created if not existent. DEFAULT: \code{\link[=locdir]{locdir()}}}

\item{force}{Logical (vector): always download, even if the file already exists in \code{dir}?
Use NA to force re-downloading files older than 24 hours.
Use a numerical value to force after that amount of hours.
Use something like \code{c(Inf, 24)} or \code{force=c(24*365, 6)}, for per="hr".
Note: if \code{force} is not FALSE, the \code{overwrite} default is TRUE.
DEFAULT: FALSE}

\item{overwrite}{Logical (vector): if force=TRUE, overwrite the existing file
rather than append "_1"/"_2" etc to the filename?
DEFAULT: \code{!isFALSE(force)}, i.e. true when \code{force} is specified.}

\item{read}{Logical: read the file(s) with \code{\link[=readDWD]{readDWD()}}? If FALSE,
only download is performed and the filename(s) returned. DEFAULT: TRUE}

\item{dbin}{Logical: Download binary file, i.e. add \code{mode="wb"} to the
\code{\link[=download.file]{download.file()}} call?
See \href{https://bookdown.org/brry/rdwd/raster-data.html#binary-file-errors}{Website}
for details.
DEFAULT: TRUE}

\item{method}{\link{download.file} \code{method}. Introduced in version 1.5.25 (2022-05-12)
as triggered by \url{https://github.com/brry/rdwd/issues/34}.
DEFAULT: \code{getOption("download.file.method")}}

\item{dfargs}{Named list of additional arguments passed to \code{\link[=download.file]{download.file()}}
Note that mode="wb" is already passed if \code{dbin=TRUE}}

\item{sleep}{Number. If not 0, a random number of seconds between 0 and
\code{sleep} is passed to \code{\link[=Sys.sleep]{Sys.sleep()}} after each download
to avoid getting kicked off the FTP-Server,
see note in \code{\link[=indexFTP]{indexFTP()}}. DEFAULT: 0}

\item{progbar}{Logical: present a progress bar with estimated remaining time?
If missing and length(file)==1, progbar is internally set to FALSE.
Only works if the R package \code{pbapply} is available. DEFAULT: TRUE (!quiet)}

\item{browse}{Logical: open repository via \code{\link[=browseURL]{browseURL()}} and
return URL folder path? If TRUE, no data is downloaded.
If file has several values, only unique folders will be opened.
DEFAULT: FALSE}

\item{ntrunc}{Single integer: number of filenames printed in messages
before they get truncated with message "(and xx more)". DEFAULT: 2}

\item{file}{Deprecated since rdwd version 1.3.34, 2020-07-28.}

\item{quiet}{Logical: suppress message about directory / filenames?
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=readDWD]{readDWD()}},
like \code{fread}, \code{varnames}, \code{hr}, etc.}
}
\value{
Presuming downloading and processing were successful:
if \code{read=TRUE}, the desired dataset
(as returned by \code{\link[=readDWD]{readDWD()}}),
otherwise the filename as saved on disc
(may have "_n" appended in name, see \code{\link[=newFilename]{newFilename()}}).\cr
If length(file)>1, the output is a list of outputs / vector of filenames.\cr
The output is always invisible.
}
\description{
Get climate data from the German Weather Service (DWD) FTP-server.
The desired dataset is downloaded into \code{dir}.
If \code{read=TRUE}, it is also read and processed.\cr
\code{dataDWD} handles vectors of URLs,
displays progress bars (if the package \code{pbapply} is available)
and by default does not re-download data already in \code{dir}
(but see argument \code{force} to update files).\cr
To solve "errors in download.file: cannot open URL", see
\url{https://bookdown.org/brry/rdwd/fileindex.html}.\cr
}
\examples{
\dontrun{ ## requires internet connection
# find FTP files for a given station name and file path:
link <- selectDWD("Fuerstenzell", res="hourly", var="wind", per="recent")
# download file:
fname <- dataDWD(link, dir=locdir(), read=FALSE) ; fname
# dir="DWDdata" is the default directory to store files
# unless force=TRUE, already obtained files will not be downloaded again

# read and plot file:
wind <- readDWD(fname, varnames=TRUE) ; head(wind)
metafiles <- readMeta(fname)          ; str(metafiles, max.level=1)
column_names <- readVars(fname)       ; head(column_names)

plot(wind$MESS_DATUM, wind$F, main="DWD hourly wind Fuerstenzell", col="blue",
     xaxt="n", las=1, type="l", xlab="Date", ylab="Hourly Wind speed  [m/s]")
berryFunctions::monthAxis(1)


# current and historical files, keep historical in the overlap time period:
link <- selectDWD("Potsdam", res="daily", var="kl", per="hr"); link
potsdam <- dataDWD(link, dir=locdir(), hr=4)
plot(TMK~MESS_DATUM, data=tail(potsdam,1500), type="l")


# With many files (>>50), use sleep to avoid getting kicked off the FTP server
#links <- selectDWD(res="daily", var="solar")
#sol <- dataDWD(links, sleep=20) # random waiting time after download (0 to 20 secs)

# Real life examples can be found in the use cases section of the vignette:
# browseURL("https://bookdown.org/brry/rdwd")
}

}
\seealso{
\code{\link[=selectDWD]{selectDWD()}}. \code{\link[=readDWD]{readDWD()}}, \code{\link[=download.file]{download.file()}}.\cr
\url{https://bookdown.org/brry/rdwd}\cr
Helpful for plotting: \code{\link[berryFunctions:monthAxis]{berryFunctions::monthAxis()}},
see also \code{\link[berryFunctions:climateGraph]{berryFunctions::climateGraph()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun-Oct 2016
}
\keyword{data}
\keyword{file}
