% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLocalTests.R
\name{runLocalTests}
\alias{runLocalTests}
\title{run local tests of rdwd}
\usage{
runLocalTests(
  dir_data = locdir(),
  dir_exmpl = berryFunctions::packagePath(file = "misc/ExampleTests"),
  fast = FALSE,
  devcheck = !fast,
  radar = !fast,
  all_Potsdam_files = !fast,
  index = !fast,
  indexfast = fast,
  examples = !fast,
  quiet = rdwdquiet()
)
}
\arguments{
\item{dir_data}{Reusable data location. Preferably not under version control.
DEFAULT: \code{\link[=locdir]{locdir()}}}

\item{dir_exmpl}{Reusable example location. DEFAULT: local directory}

\item{fast}{Exclude many tests? DEFAULT: FALSE}

\item{devcheck}{Run \code{devtools::check()}? DEFAULT: !fast}

\item{radar}{Test reading radar example files. DEFAULT: !fast}

\item{all_Potsdam_files}{Read all (ca 60) files for Potsdam? Re-downloads if
files are older than 24 hours. Reduce test time a lot by setting
this to FALSE. DEFAULT: !fast}

\item{index}{Run \code{\link[=checkIndex]{checkIndex()}}? DEFAULT: !fast}

\item{indexfast}{\code{fast} option passed to \code{\link[=checkIndex]{checkIndex()}}. DEFAULT: !fast}

\item{examples}{Run Examples (including donttest sections) DEFAULT: !fast}

\item{quiet}{Suppress progress messages? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}
}
\value{
Time taken to run tests in minutes
}
\description{
Run \code{rdwd} tests on local machine. Due to time-intensive
data downloads, these tests are not run automatically on CRAN.
}
\seealso{
\code{\link[=locdir]{locdir()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr-Oct 2019
}
\keyword{debugging}
