% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_listidentifiers.r
\name{dr_list_identifiers}
\alias{dr_list_identifiers}
\title{Gets OAI Dryad identifiers}
\usage{
dr_list_identifiers(prefix = "oai_dc", from = NULL, until = NULL,
  set = "hdl_10255_3", token = NULL, as = "df", ...)
}
\arguments{
\item{prefix}{A character string to specify the metadata format in OAI-PMH requests issued to
the repository. The default (\code{"oai_dc"}) corresponds to the mandatory OAI unqualified
Dublin Core metadata schema.}

\item{from}{Character string giving datestamp to be used as lower bound for datestamp-based
selective harvesting (i.e., only harvest records with datestamps in the given range). Dates
and times must be encoded using ISO 8601. The trailing Z must be used when including time.
OAI-PMH implies UTC for data/time specifications.}

\item{until}{Character string giving a datestamp to be used as an upper bound,
for datestamp-based selective harvesting (i.e., only harvest records with datestamps in
the given range).}

\item{set}{A character string giving a set to be used for selective harvesting (i.e., only
harvest records in the given set).}

\item{token}{(character) a token previously provided by the server to resume a
request where it last left off. 50 is max number of records returned. We will
loop for you internally to get all the records you asked for.}

\item{as}{(character) What to return. One of "df" (for data.frame; default),
"list", or "raw" (raw text)}

\item{...}{Curl debugging options passed on to \code{\link[httr]{GET}}}
}
\value{
XML character string, data.frame, or list, depending on what requested
witht the \code{as} parameter

List of OAI identifiers for each dataset.
}
\description{
Gets OAI Dryad identifiers
}
\examples{
\dontrun{
dr_list_identifiers(from='2010-01-01', until = "2010-06-30")
dr_list_identifiers(set="geocode1", from='2015-09-01', until='2015-09-05')
dr_list_identifiers(prefix="iso19139", from='2015-09-01', until='2015-09-20')
dr_list_identifiers(prefix="dif", from='2015-09-01', until='2015-09-20')

identifiers <- dr_list_identifiers('r')

# Data packages
identifiers[[1]]

# Data files
identifiers[[2]]
}
}

