% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdhte.R
\name{rdhte}
\alias{rdhte}
\title{RD Heterogeneous Treatment Effects Estimation and Inference}
\usage{
rdhte(
  y,
  x,
  c = 0,
  covs.hte = NULL,
  covs.eff = NULL,
  p = 1,
  kernel = "tri",
  h = NULL,
  vce = "hc3",
  cluster = NULL,
  level = 95,
  bw.joint = FALSE
)
}
\arguments{
\item{y}{Outcome variable.}

\item{x}{Running variable.}

\item{c}{Cutoff value (default = 0).}

\item{covs.hte}{Covariate(s) for heterogeneous treatment effects (required).}

\item{covs.eff}{Additional covariates for efficiency (optional).}

\item{p}{Polynomial order (default = 1).}

\item{kernel}{Kernel type (default = "tri").}

\item{h}{Choice of bandwidth (optional).}

\item{vce}{Variance estimator (default = "hc3").}

\item{cluster}{Optional cluster variable.}

\item{level}{Confidence level (default = 95).}

\item{bw.joint}{Logical, use joint bandwidth selection (default = FALSE).}
}
\value{
A list with selected RD HTE effects and model information.
\item{Estimate}{vector of conventional local-polynomial RD estimates.}
\item{Estimate_bc}{vector of bias-corrected local-polynomial RD estimates.}
\item{se_rb}{vector containing robust bias corrected standard errors of the local-polynomial RD estimates.}
\item{ci_rb}{matrix containing robust bias corrected confidence intervals.}
\item{t_rb}{vector containing the t-statistics associated with robust local-polynomial RD estimates.}
\item{pv_rb}{vector containing the p-values associated with robust local-polynomial RD estimates.}
\item{coefs}{vector containing the coefficients for the jointly estimated p-th order local polynomial model.}
\item{vcov}{estimated variance-covariance matrix.}
\item{W_lev}{vector of group level identifiers.}
\item{kernel}{kernel type used.}
\item{vce}{variance estimator used.}
\item{c}{cutoff value.}
\item{h}{vector containing the bandwidths used.}
\item{p}{order of the polynomial used for estimation of the regression function.}
\item{N}{vector with the original number of observations for each group.}
\item{Nh}{vector with the effective number of observations for each group.}
\item{coef_report}{internal value.}
\item{level}{confidence level used.}
\item{rdmodel}{rd model.}
}
\description{
\code{rdhte} provides estimation and inference for heterogeneous
treatment effects in RDD using local polynomial regression
allowing for interactions with pretreatment covariates.
Inference is implemented using robust bias-correction methods.

Companion commands: \code{\link{rdbwhte}} for data-driven bandwidth selection.

Related Stata and R packages useful for inference in RD designs are described
in the website: \url{https://rdpackages.github.io/}.
}
\examples{
set.seed(123)
n <- 5000
X <- runif(n, -1, 1)
W <- rbinom(n, 1, 0.5)
Y <- 3 + 2*X + 1.5*X^2 + 0.5*X^3 + sin(2*X) + 3*W*(X>=0) + rnorm(n)
rdhte.1 = rdhte(y=Y, x=X, covs.hte=factor(W))
summary(rdhte.1)
}
\references{
Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): rdhte: Learning Conditional Average Treatment Effects in RD Designs. \emph{Working paper}.

Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): Treatment Effect Heterogeneity in Regression Discontinuity Designs. \emph{Working paper}
}
\seealso{
\code{\link{rdbwhte}}
}
\author{
Sebastian Calonico, University of California, Davis \email{scalonico@ucdavis.edu}.

Matias D. Cattaneo, Princeton University  \email{cattaneo@princeton.edu}.

Max H. Farrell, University of California, Santa Barbara \email{maxhfarrell@ucsb.edu}.

Filippo Palomba, Princeton University \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University \email{titiunik@princeton.edu}.
}
