% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes.R
\name{download_boundaries}
\alias{download_boundaries}
\title{DHS Spatial Boundaries}
\usage{
download_boundaries(
  surveyNum = NULL,
  surveyId = NULL,
  countryId = NULL,
  method = "sf",
  quiet_download = FALSE,
  quiet_parse = TRUE
)
}
\arguments{
\item{surveyNum}{Numeric for the survey number to be downloaded. Values for
surveyNum can be found in the datasets or surveys endpoints in the DHS API
that can be accessed using \code{\link{dhs_datasets}} and
\code{\link{dhs_surveys}}. Default is NULL, which will cause the SurveyId
to be used to find the survey.}

\item{surveyId}{Numeric for the survey ID to be downloaded. Values for
surveyId can be found in the datasets or surveys endpoints in the DHS API
that can be accessed using \code{\link{dhs_datasets}} and
\code{\link{dhs_surveys}}. Default is NULL, which will cause the SurveyNum
to be used to find the survey.}

\item{countryId}{2-letter DHS country code for the country of the survey
being downloaded. Default = NULL, which will cause the countrycode to be
looked up from the API.}

\item{method}{Character for how the downloaded shape file is read in.
Default = "sf", which uses \code{sf::st_read}. Currenlty, you can also
specify "rgdal", which reads the file using rgdal::readOGR.
To just return the file paths for the files use method = "zip".}

\item{quiet_download}{Whether to download file quietly. Passed to
[`download_file()`]. Default is `FALSE`.}

\item{quiet_parse}{Whether to read boundaries dataset quietly. Applies to
`method = "sf"`. Default is `TRUE`.}
}
\value{
Returns either the spatial file as a "SpatialPolygonsDataFrame" or
  a vector of the file paths of where the boundary was downloaded to.
}
\description{
Download Spatial Boundaries
}
\details{
Downloads the spatial boundaries from the DHS spatial repository,
  which can be found at \url{https://spatialdata.dhsprogram.com/home/}.
}
\examples{
\dontrun{
 # using the surveyNum
 res <- download_boundaries(surveyNum = 471, countryId = "AF")

 # using the surveyId and no countryID
 res <- download_boundaries(surveyId = "AF2010OTH")

 # using rgdal
 res <- download_boundaries(surveyNum = 471, countryId = "AF", method = "rgdal")
 }
}
