% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukair_get_hourly_data.R
\name{ukair_get_hourly_data}
\alias{ukair_get_hourly_data}
\title{Get hourly data for DEFRA stations}
\usage{
ukair_get_hourly_data(site_id = NULL, years = NULL)
}
\arguments{
\item{site_id}{This is the ID of a specific site.}

\item{years}{Years for which data should be downloaded.}
}
\value{
A data.frame containing hourly pollution data.
}
\description{
This function fetches hourly data from DEFRA's air pollution monitoring stations.
}
\details{
The measurements are generally in \eqn{\mu g/m^3} (micrograms per cubic metre). To check the units, refer to the table of attributes (see example below). Please double check the units on the DEFRA website, as they might change over time.
}
\examples{
 \dontrun{
 # Get data for 1 year
 output <- ukair_get_hourly_data("ABD", 2014)

 # Get data for multiple years
 output <- ukair_get_hourly_data("ABD", 2014:2016)

 # Get units
 attributes(output)$units

 }

}

