% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reaction.R
\docType{class}
\name{Reaction}
\alias{Reaction}
\title{A reaction (chance) edge in a decision tree}
\description{
An R6 class representing a reaction (chance) edge in a decision 
tree.
}
\details{
A specialism of class \code{Arrow} which is used in a decision tree
to represent edges whose source nodes are \code{ChanceNode}s.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Edge]{rdecision::Edge}} -> \code{\link[rdecision:Arrow]{rdecision::Arrow}} -> \code{Reaction}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Reaction-new}{\code{Reaction$new()}}
\item \href{#method-Reaction-modvars}{\code{Reaction$modvars()}}
\item \href{#method-Reaction-p}{\code{Reaction$p()}}
\item \href{#method-Reaction-cost}{\code{Reaction$cost()}}
\item \href{#method-Reaction-benefit}{\code{Reaction$benefit()}}
\item \href{#method-Reaction-clone}{\code{Reaction$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="endpoints"><a href='../../rdecision/html/Edge.html#method-Edge-endpoints'><code>rdecision::Edge$endpoints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="is_same_edge"><a href='../../rdecision/html/Edge.html#method-Edge-is_same_edge'><code>rdecision::Edge$is_same_edge()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="label"><a href='../../rdecision/html/Edge.html#method-Edge-label'><code>rdecision::Edge$label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="source"><a href='../../rdecision/html/Arrow.html#method-Arrow-source'><code>rdecision::Arrow$source()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="target"><a href='../../rdecision/html/Arrow.html#method-Arrow-target'><code>rdecision::Arrow$target()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reaction-new"></a>}}
\if{latex}{\out{\hypertarget{method-Reaction-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \code{Reaction}. A probability must be assigned
to the edge. Optionally, a cost and a benefit may be associated
with traversing the edge. A \dfn{pay-off} (benefit-cost) is sometimes
used in edges of decision trees; the parametrization used here is more
general.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$new(source, target, p, cost = 0, benefit = 0, label = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{Chance node from which the arrow leaves.}

\item{\code{target}}{Node which the arrow enters.}

\item{\code{p}}{Probability}

\item{\code{cost}}{Cost associated with traversal of this edge.}

\item{\code{benefit}}{Benefit associated with traversal of the edge.}

\item{\code{label}}{Character string containing the arrow label.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Reaction} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reaction-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-Reaction-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables of type \code{ModVar} that have been 
specified
as values associated with this Action. Includes operands of these
\code{ModVar}s, if they are expressions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$modvars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reaction-p"></a>}}
\if{latex}{\out{\hypertarget{method-Reaction-p}{}}}
\subsection{Method \code{p()}}{
Return the current value of the edge probability, i.e. the conditional
probability of traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$p()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric value in range [0,1].
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reaction-cost"></a>}}
\if{latex}{\out{\hypertarget{method-Reaction-cost}{}}}
\subsection{Method \code{cost()}}{
Return the cost associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$cost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Cost.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reaction-benefit"></a>}}
\if{latex}{\out{\hypertarget{method-Reaction-benefit}{}}}
\subsection{Method \code{benefit()}}{
Return the benefit associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$benefit()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Benefit.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reaction-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Reaction-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
