% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GammaModVar.R
\docType{class}
\name{GammaModVar}
\alias{GammaModVar}
\title{\verb{GammaModVar} class}
\description{
An R6 class for a model variable with Gamma function uncertainty
}
\details{
A model variable for which the uncertainty in the point estimate can
be modelled with a Gamma distribution. The hyperparameters of the
distribution are the shape (\code{alpha}) and the rate (\code{beta}) of
the uncertainty distribution. Note that this is the conventional
parametrization used in Bayesian statistics; in econometrics the
shape/scale (\code{k}/\code{theta}) parametrization is more common (and the
one used in this implementation). Note, however, that although Briggs 
\emph{et al} (2006) use the shape/scale formulation, they use 
\code{alpha}/\code{beta} as parameter names.
}
\note{
The Gamma model variable class can be used to model the uncertainty of
the mean of a count quantity which follows a Poisson distribution. The Gamma
distribution is the conjugate prior of a Poisson distribution, and the shape
and scale relate directly to the number of intervals from which the mean
count has been estimated. Specifically, the shape (\eqn{k}) is equal to the 
total count of events in \eqn{1/\theta} intervals, where \eqn{\theta} is the
scale. For example, if 200 counts were observed in a sample of 100 intervals, 
setting \code{shape=200} and \code{scale=1/100} gives a Gamma distribution 
with a mean of 2 and a 95\% confidence interval from 1.73 to 2.29.
}
\references{
{
  Briggs A, Claxton K, Sculpher M. Decision modelling for health
  economic evaluation. Oxford, UK: Oxford University Press; 2006. 
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:ModVar]{rdecision::ModVar}} -> \code{GammaModVar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GammaModVar$new()}}
\item \href{#method-is_probabilistic}{\code{GammaModVar$is_probabilistic()}}
\item \href{#method-distribution}{\code{GammaModVar$distribution()}}
\item \href{#method-mean}{\code{GammaModVar$mean()}}
\item \href{#method-mode}{\code{GammaModVar$mode()}}
\item \href{#method-SD}{\code{GammaModVar$SD()}}
\item \href{#method-r}{\code{GammaModVar$r()}}
\item \href{#method-quantile}{\code{GammaModVar$quantile()}}
\item \href{#method-clone}{\code{GammaModVar$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="description">}\href{../../rdecision/html/ModVar.html#method-description}{\code{rdecision::ModVar$description()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="get">}\href{../../rdecision/html/ModVar.html#method-get}{\code{rdecision::ModVar$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="is_expression">}\href{../../rdecision/html/ModVar.html#method-is_expression}{\code{rdecision::ModVar$is_expression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="set">}\href{../../rdecision/html/ModVar.html#method-set}{\code{rdecision::ModVar$set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="units">}\href{../../rdecision/html/ModVar.html#method-units}{\code{rdecision::ModVar$units()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of class \code{GammaModVar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$new(description, units, shape, scale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{A character string describing the variable.}

\item{\code{units}}{Units of the variable, as character string.}

\item{\code{shape}}{shape parameter of the Gamma distribution.}

\item{\code{scale}}{scale parameter of the Gamma distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{GammaModVar}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic, i.e. a random
variable that follows a distribution, or an expression involving
random variables, some of which follow distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if probabilistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Return the expected value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mode"></a>}}
\if{latex}{\out{\hypertarget{method-mode}{}}}
\subsection{Method \code{mode()}}{
Return the mode of the distribution (if \code{shape} >= 1)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
mode as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SD"></a>}}
\if{latex}{\out{\hypertarget{method-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-r"></a>}}
\if{latex}{\out{\hypertarget{method-r}{}}}
\subsection{Method \code{r()}}{
Draw a random sample from the model variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$r(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of samples to draw.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Samples drawn at random.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Return the quantiles of the Gamma uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Vector of probabilities, in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of quantiles.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
