% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{ddi_method}
\alias{ddi_method}
\alias{ddi_dataProcessing}
\alias{ddi_stdyClas}
\title{method and its child nodes}
\usage{
ddi_method(...)

ddi_dataProcessing(...)

ddi_stdyClas(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
This section describes the methodology and processing involved in a data
collection. More information on these elements, especially their allowed
attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{method} is contained in \code{stdyDscr}.

\emph{method specific child nodes}
\itemize{
\item \code{ddi_dataProcessing()} describes various data processing procedures not
captured elsewhere in the documentation, such as topcoding, recoding,
suppression, tabulation, etc. The "type" attribute supports better
classification of this activity, including the optional use of a controlled
vocabulary.
\item \code{ddi_stdyClas()} is generally used to give the data archive's class or
study status number, which indicates the processing status of the study. May
also be used as a text field to describe processing status. This element may
be repeated to support multiple language expressions of the content.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_anlyInfo]{ddi_anlyInfo()}}
\item \code{\link[=ddi_codingInstructions]{ddi_codingInstructions()}}
\item \code{\link[=ddi_dataColl]{ddi_dataColl()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
}
}

\examples{
ddi_method()

# Functions that need to be wrapped in ddi_method()

ddi_dataProcessing(type = "topcoding",
                   "The income variables in this study (RESP_INC, HHD_INC, and 
                   SS_INC) were topcoded to protect confidentiality.")

ddi_stdyClas("ICPSR Class II")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/method.html}{method documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/dataProcessing.html}{dataProcessing documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/stdyClas.html}{stdyClas documentation}
}
