% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocs.R
\name{ocs_find_users}
\alias{ocs_find_users}
\title{Search for users one could share data}
\usage{
ocs_find_users(req, search, lookup = FALSE, as_df = TRUE)
}
\arguments{
\item{req}{WebDAV request as returned by \code{\link{wd_connect}}}

\item{search}{search string (e.g. user name, e-mail, group name)}

\item{lookup}{if TRUE (and supported) search on Nextcloud lookup server}

\item{as_df}{if TRUE (default) a data.frame is returned, else a list of IDs}
}
\value{
data.frame with user informations or named vector of user ids.
}
\description{
Search for users one could share data
}
\examples{
\dontrun{
r <- wd_connect("https://example.com/remote.php/dav/files/johndoe")
ocs_find_users(r, "Doe, Jack")
}
}
