% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{install}
\alias{install}
\title{Install datasets via the Data Retriever (deprecated).}
\usage{
install(dataset, connection, db_file = NULL, conn_file = NULL,
  data_dir = ".", log_dir = NULL)
}
\arguments{
\item{dataset}{the name of the dataset that you wish to download}

\item{connection}{what type of database connection should be used.
The options include: mysql, postgres, sqlite, msaccess, or csv'}

\item{db_file}{the name of the datbase file the dataset should be loaded
into}

\item{conn_file}{the path to the .conn file that contains the connection
configuration options for mysql and postgres databases. This defaults to
mysql.conn or postgres.conn respectively. The connection file is a file that
is formated in the following way:
\tabular{ll}{
  host     \tab my_server@my_host.com\cr
  port     \tab my_port_number       \cr
  user     \tab my_user_name         \cr
  password \tab my_password
}}

\item{data_dir}{the location where the dataset should be installed.
Only relevant for csv connection types. Defaults to current working directory}

\item{log_dir}{the location where the retriever log should be stored if
the progress is not printed to the console}
}
\description{
Data is stored in either CSV files or one of the following database management
systems: MySQL, PostgreSQL, SQLite, or Microsoft Access.
}
\examples{
\donttest{
rdataretriever::install('iris', 'csv')
}
}
