% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_data.R
\docType{data}
\name{sf_bos_clean}
\alias{sf_bos_clean}
\title{Cleaned ballot image data from a San Francisco RCV election}
\format{A data frame with 643806 rows and 9 variables:
\describe{
  \item{contest}{which election this candidate ranking applies to}
  \item{pref_voter_id}{a unique key identifying an individual voter }
  \item{serial_number}{the serial number of the voting machine used}
  \item{tally}{contains information about whether the ballot was cast
  in early voting, was filed provisionally, and other factors}
  \item{precinct}{which city precinct the voter voted in}
  \item{vote_rank}{the rank given to the candidate by the voter; in
  the San Francisco case can take values of 1, 2, or 3}
  \item{candidate}{the chosen candidate for the specified vote rank}
  \item{over_vote}{a dummy variable, coded 1 if the ballot shows more
  votes cast than the number of candidates to be elected}
  \item{under_vote}{a dummy variable, coded 1 if the ballot shows no
  valid selection made for a candidate}
  }}
\usage{
sf_bos_clean
}
\description{
A tidied version of `sf_bos_ballot` in a "tall" format,
readable to see voters' information, including candidate
rankings, precinct, and over-/under-vote codings. Cleaned
with clean_ballot.
clean_ballot(sf_bos_ballot, b_header = T,
             sf_bos_lookup, l_header = T,
             format = "WinEDS")
}
\keyword{datasets}
