% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reproject}
\alias{reproject}
\title{Reproject a raster or vector dataset to the specified
coordinate reference system (CRS)}
\usage{
reproject(x, crs, ...)
}
\arguments{
\item{x}{Raster (\code{SpatRaster}) or vector (\code{sf}) object}

\item{crs}{CRS to be projected to, provided as \code{numeric}, \code{integer} or
\code{logical} vector of length one or \code{\link[sf:coerce-methods]{sf::crs}}. If \code{numeric}, the value
should be a positive number with unrestricted upper bound representing
a valid EPSG code.}

\item{...}{Optional arguments for raster or vector reproject functions}
}
\value{
\code{\link[sf:sf]{sf::sf}}, \code{\link[sf:sfc]{sf::sfc}}, or \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} object reprojected
to specified CRS
}
\description{
Reproject a raster or vector dataset to the specified
coordinate reference system (CRS)
}
\examples{
# Reproject a raster to EPSG:4326
r <- terra::rast(matrix(1:12, nrow = 3, ncol = 4), crs = "EPSG:32633")
reproject(r, 4326)
}
