% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrame.R
\name{CMBDataFrame}
\alias{CMBDataFrame}
\title{CMBDataFrame class}
\usage{
CMBDataFrame(
  CMBData,
  coords,
  win,
  include.polar = FALSE,
  include.masks = FALSE,
  spix,
  sample.size,
  nside,
  ordering,
  I,
  ...
)
}
\arguments{
\item{CMBData}{Can be a string location of FITS file,
another \code{CMBDataFrame}, a \code{CMBDat} object,
a \code{\link{HPDataFrame}} or unspecified.}

\item{coords}{Can be "spherical," "cartesian", or unspecified (HEALPix only).}

\item{win}{optional \code{\link{CMBWindow}} object that specifies a
spherical polygon within which to subset the full sky CMB data.}

\item{include.polar}{TRUE if polarisation data is required, otherwise FALSE.}

\item{include.masks}{TRUE if TMASK and PMASK are required, otherwise FALSE.}

\item{spix}{Optional vector of sample pixel indices, or a path to a file
containing comma delimited sample pixel indices. The ordering scheme is
given by \code{ordering}. If \code{ordering} is unspecified then
CMBData must be either a CMBDataFrame or a FITS file and the ordering
scheme is then assumed to match that of CMBData.}

\item{sample.size}{If a positive integer is given, a simple random
sample of size equal to sample.size will be taken from CMBData. If
spix is specified then \code{sample.size} must be unspecified.}

\item{nside}{Optionally specify the nside parameter manually nside=\eqn{2^k}
(usually 1024 or 2048).}

\item{ordering}{Specifies the desired HEALPix ordering scheme
("ring" or "nested") for the output CMBDataFrame.
If \code{ordering} is unspecified then the ordering
scheme will be taken from the CMBData object. If ordering information
cannot be found the default will be "nested". This parameter also specifies
the ordering scheme of \code{spix}.}

\item{I}{A vector of intensities to be included
if \code{CMBData} is unspecified. Note that \code{length(I)}
must equal \eqn{12*nside^2} if either spix or
sample.size are unspecified.}

\item{...}{Optional names data columns of length nrow(CMBData) to
add to the CMBDataFrame.}
}
\value{
A \code{CMBDataFrame} whose \code{row.names} attribute contains
HEALPix indices.
}
\description{
The function \code{CMBDataFrame} creates objects of class \code{CMBDataFrame}.
These are a special type of \code{\link{data.frame}} that carry metadata
about, e.g., the HEALPix ordering scheme, coordinate system, and nside parameter.
}
\examples{
## Method 1: Read the data while constructing the CMBDataFrame
## download a FITS file and use real data
# downloadCMBMap()
# df <- CMBDataFrame("CMB_map_smica1024.fits")
df <- CMBDataFrame(nside = 16, I = rnorm(12 * 16 ^ 2),
                   ordering = "nested")

# Specify a sample size for a random sample
df.sample <- CMBDataFrame(df, sample.size = 80)
plot(df.sample)

# Specify a vector of pixel indices using spix
df.subset <- CMBDataFrame(df, spix = c(2,4,6))

# Take a look at the summary
summary(df)

# Access HEALPix pixel indices using pix function
# (these are stored in the row.names attribute)
pix(df.subset)



}
