% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwisePermutationMatrix.r
\name{pairwisePermutationMatrix}
\alias{pairwisePermutationMatrix}
\title{Pairwise two-sample permutation tests with matrix output}
\usage{
pairwisePermutationMatrix(x, g, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{independence_test}}.}
}
\value{
A list consisting of:
        A matrix of p-values;
        the p-value adjustment method;
        a matrix of adjusted p-values.
}
\description{
Conducts pairwise two-sample permutation tests across groups.
}
\details{
Permutation tests are non-parametric tests 
         that do not assume normally-distributed errors.
         See \url{http://rcompanion.org/handbook/K_02.html} for
         futher discussion of this test.

         The \code{pairwisePermutationTest} function
         can be used as a post-hoc method following an omnibus 
         permutation test analogous to a one-way analysis
         of variance.
         The matrix output can be converted to a compact letter display.
}
\examples{
data(PoohPiglet)
PoohPiglet = PoohPiglet[order(factor(PoohPiglet$Speaker, 
                        levels=c("Pooh", "Tigger", "Piglet"))),]               
PT = pairwisePermutationMatrix(x      = PoohPiglet$Likert,
                               g      = PoohPiglet$Speaker,
                               exact  = NULL,
                               method = "fdr")$Adjusted
PT
library(multcompView)
multcompLetters(PT,
                compare="<",
                threshold=0.05,
                Letters=letters)   

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/rcompanion/d_06a.html}
}
\seealso{
\code{\link{pairwisePermutationTest}}
}
\concept{
permutation nonparametric post-hoc one-way cld
}

