% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cit_oid.R
\name{cit_oid}
\alias{cit_oid}
\alias{cit_oid_}
\title{Get Citoid data}
\usage{
cit_oid(id, format = "mediawiki", accept_language = NULL, ...)

cit_oid_(id, format = "mediawiki", accept_language = NULL, ...)
}
\arguments{
\item{id}{(character) id of an article, DOI, ISBN, PMCID or PMID}

\item{format}{(character) the format to use for the resulting citation data.
one of mediawiki (default), zotero, mediawiki-basefields, bibtex}

\item{accept_language}{(character) for some articles the result depends on
the accept language value, so provide it if localized content is required}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
list of lists or character, see
http://opencitations.net/index/coci/api/v1 for explanation of the resulting
columns
}
\description{
Get Citoid data
}
\details{
\code{cit_oid_()} gets raw text (either bibtex or JSON), and \code{cit_oid()}
parses the text as appropriate for the type
}
\examples{
url<-"https://en.wikipedia.org/api/rest_v1/data/citation/mediawiki/30446726"
if (crul::ok(url)) {
  pmid1 <- 30446726
  cit_oid(pmid1)
}

\dontrun{
doi1 <- "10.1108/jd-12-2013-0166"
doi2 <- "10.1371/journal.pone.0058568"
pmid1 <- 30446726
pmcid1 <- "PMC4679344"
isbn1 <- 1439895619

# different formats
cit_oid(doi1)
cit_oid(pmid1, format = "mediawiki")
cit_oid(pmid1, format = "zotero")
cit_oid(pmid1, format = "mediawiki-basefields")
cat(cit_oid(pmid1, format = "bibtex")[[1]])

# PMID example
cit_oid(pmid1, verbose = TRUE)

# ISBN example
cit_oid(isbn1, verbose = TRUE)

# PMCID example
cit_oid(pmcid1)

# set the accept language
x <- cit_oid(pmid1, accept_language = "fr-FR", verbose = TRUE)
x <- cit_oid(doi2, accept_language = "de-DE", verbose = TRUE)

# just get raw text/json
cit_oid_(pmcid1)

# many ids at once
cit_oid(id = c(pmid1, pmcid1, isbn1))
cit_oid_(id = c(pmid1, pmcid1, isbn1))
cit_oid_(id = c(pmid1, pmcid1, isbn1), format = "bibtex")
}
}
\references{
https://en.wikipedia.org/api/rest_v1/#!/Citation/getCitation,
https://www.mediawiki.org/wiki/Citoid
}
