% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{data_partition}
\alias{data_partition}
\title{Data partitionning function adapted from the caret package.}
\usage{
data_partition(y, p = 0.5, groups = min(5, length(y)))
}
\arguments{
\item{y}{a vector of outcomes.}

\item{p}{the percentage of data that goes to training}

\item{groups}{for numeric \code{y}, the number of breaks in the quantiles
(see below)}
}
\value{
A vector of row position integers corresponding to the training data
}
\description{
\code{data_partition} creates a test/training partition.
}
\details{
The random sampling is done within the levels of \code{y} when \code{y} is a 
factor in an attempt to balance the class distributions within the splits.

For numeric \code{y}, the sample is split into groups sections based on
percentiles and sampling is done within these subgroups. The number of 
percentiles is set via the \code{groups} argument.

Also, very small class sizes (<= 3) the
classes may not show up in both the training and test data
}
\author{
adapted from \code{\link[caret]{createDataPartition}} function by Max Kuhn
}
\references{
\url{http://caret.r-forge.r-project.org/splitting.html}
}
\keyword{internal}
\keyword{utilities,}

