/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import java.util.StringTokenizer;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV3000Reader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLRXNV3000Format;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MDLRXNV3000Reader
extends DefaultChemObjectReader {
    BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLRXNV3000Reader.class);

    public MDLRXNV3000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV3000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
    }

    public MDLRXNV3000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV3000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLRXNV3000Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return MDLRXNV3000Format.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IReaction.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (!IReaction.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IReaction) {
            return (T)this.readReaction(object.getBuilder());
        }
        if (object instanceof IChemModel) {
            IChemModel model = (IChemModel)object.getBuilder().newInstance(IChemModel.class, new Object[0]);
            IReactionSet reactionSet = (IReactionSet)object.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            reactionSet.addReaction(this.readReaction(object.getBuilder()));
            model.setReactionSet(reactionSet);
            return (T)model;
        }
        throw new CDKException("Only supported are Reaction and ChemModel, and not " + object.getClass().getName() + ".");
    }

    private String readCommand() throws CDKException {
        String line = this.readLine();
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand();
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    private String readLine() throws CDKException {
        String line;
        try {
            line = this.input.readLine();
            logger.debug((Object)("read line: " + line));
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        return line;
    }

    private IReaction readReaction(IChemObjectBuilder builder) throws CDKException {
        IReaction reaction = (IReaction)builder.newInstance(IReaction.class, new Object[0]);
        this.readLine();
        this.readLine();
        this.readLine();
        this.readLine();
        int reactantCount = 0;
        int productCount = 0;
        int agentCount = 0;
        boolean foundCOUNTS = false;
        while (this.isReady() && !foundCOUNTS) {
            String command = this.readCommand();
            if (command.startsWith("COUNTS")) {
                StringTokenizer tokenizer = new StringTokenizer(command);
                try {
                    tokenizer.nextToken();
                    reactantCount = Integer.parseInt(tokenizer.nextToken());
                    logger.info((Object)("Expecting " + reactantCount + " reactants in file"));
                    productCount = Integer.parseInt(tokenizer.nextToken());
                    logger.info((Object)("Expecting " + productCount + " products in file"));
                    if (tokenizer.hasMoreTokens()) {
                        agentCount = Integer.parseInt(tokenizer.nextToken());
                        logger.info((Object)("Expecting " + agentCount + " products in file"));
                        if (this.mode == IChemObjectReader.Mode.STRICT && agentCount > 0) {
                            throw new CDKException("RXN files uses agent count extension");
                        }
                    }
                }
                catch (Exception exception) {
                    logger.debug((Object)exception);
                    throw new CDKException("Error while counts line of RXN file", (Throwable)exception);
                }
                foundCOUNTS = true;
                continue;
            }
            logger.warn((Object)("Waiting for COUNTS line, but found: " + command));
        }
        this.readMols(builder, reaction, ReactionRole.Reactant, reactantCount);
        this.readMols(builder, reaction, ReactionRole.Product, productCount);
        this.readMols(builder, reaction, ReactionRole.Agent, agentCount);
        return reaction;
    }

    private void readMols(IChemObjectBuilder builder, IReaction reaction, ReactionRole role, int count) throws CDKException {
        if (count == 0) {
            return;
        }
        String command = this.readCommand();
        if (!command.equals("BEGIN " + role.name().toUpperCase(Locale.ROOT))) {
            throw new CDKException("Expected start of " + role + "s  but got: " + command);
        }
        StringBuilder molFile = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String molFileLine;
            molFile.setLength(0);
            command = this.readCommand();
            if (!command.endsWith("BEGIN CTAB")) {
                String error = "Excepted start of " + role + " CTAB, but found: " + command;
                logger.error((Object)error);
                throw new CDKException(error);
            }
            while ((molFileLine = this.readLine()) != null) {
                molFile.append(molFileLine).append('\n');
                if (!molFileLine.endsWith("END CTAB")) continue;
            }
            try {
                MDLV3000Reader reader = new MDLV3000Reader(new StringReader(molFile.toString()), this.mode);
                IAtomContainer mol = reader.read(builder.newAtomContainer());
                reader.close();
                switch (role) {
                    case Reactant: {
                        reaction.addReactant(mol);
                        break;
                    }
                    case Agent: {
                        reaction.addAgent(mol);
                        break;
                    }
                    case Product: {
                        reaction.addProduct(mol);
                    }
                }
                continue;
            }
            catch (IOException | IllegalArgumentException | CDKException exception) {
                String error = "Error while reading reactant: " + exception.getMessage();
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, exception);
            }
        }
        command = this.readCommand();
        if (!command.equals("END " + role.name().toUpperCase(Locale.ROOT))) {
            throw new CDKException("Expected end of " + role + "s  but got: " + command);
        }
    }

    private boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
    }

    public boolean accepts(IChemObject object) {
        if (object instanceof IReaction) {
            return true;
        }
        return object instanceof IChemModel;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
    }
}

