/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.tools;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smsd.helper.BondEnergy;

@Deprecated
public class BondEnergies {
    private static Map<Integer, BondEnergy> bondEngergies = null;
    private static BondEnergies instance = null;

    public static synchronized BondEnergies getInstance() throws CDKException {
        if (null == instance) {
            instance = new BondEnergies();
        }
        return instance;
    }

    protected BondEnergies() {
        int key = 1;
        bondEngergies = Collections.synchronizedSortedMap(new TreeMap());
        key = this.setHydrogenBlock(key);
        key = this.setGroup13(key);
        key = this.setGroup14Part1(key);
        key = this.setGroup14Part2(key);
        key = this.setGroup15(key);
        key = this.setGroup16(key);
        key = this.setGroup17(key);
        key = this.setGroup18(key);
    }

    public int getEnergies(IAtom sourceAtom, IAtom targetAtom, IBond.Order bondOrder) {
        int dKJPerMol = -1;
        for (Map.Entry<Integer, BondEnergy> entry : bondEngergies.entrySet()) {
            IBond.Order order;
            BondEnergy bondEnergy = entry.getValue();
            String atom1 = bondEnergy.getSymbolFirstAtom();
            String atom2 = bondEnergy.getSymbolSecondAtom();
            if ((!atom1.equalsIgnoreCase(sourceAtom.getSymbol()) || !atom2.equalsIgnoreCase(targetAtom.getSymbol())) && (!atom2.equalsIgnoreCase(sourceAtom.getSymbol()) || !atom1.equalsIgnoreCase(targetAtom.getSymbol())) || (order = bondEnergy.getBondOrder()).compareTo((Enum)bondOrder) != 0) continue;
            dKJPerMol = bondEnergy.getEnergy();
        }
        return dKJPerMol;
    }

    public int getEnergies(String sourceAtom, String targetAtom, IBond.Order bondOrder) {
        int dKJPerMol = -1;
        for (Map.Entry<Integer, BondEnergy> entry : bondEngergies.entrySet()) {
            IBond.Order order;
            BondEnergy bondEnergy = entry.getValue();
            String atom1 = bondEnergy.getSymbolFirstAtom();
            String atom2 = bondEnergy.getSymbolSecondAtom();
            if ((!atom1.equalsIgnoreCase(sourceAtom) || !atom2.equalsIgnoreCase(targetAtom)) && (!atom2.equalsIgnoreCase(sourceAtom) || !atom1.equalsIgnoreCase(targetAtom)) || (order = bondEnergy.getBondOrder()).compareTo((Enum)bondOrder) != 0) continue;
            dKJPerMol = bondEnergy.getEnergy();
        }
        return dKJPerMol;
    }

    public int getEnergies(IBond bond) {
        int dKJPerMol = -1;
        for (Map.Entry<Integer, BondEnergy> entry : bondEngergies.entrySet()) {
            BondEnergy bondEnergy = entry.getValue();
            if (!bondEnergy.matches(bond)) continue;
            dKJPerMol = bondEnergy.getEnergy();
        }
        return dKJPerMol;
    }

    private int setHydrogenBlock(int key) {
        bondEngergies.put(key++, new BondEnergy("H", "H", IBond.Order.SINGLE, 432));
        bondEngergies.put(key++, new BondEnergy("H", "B", IBond.Order.SINGLE, 389));
        bondEngergies.put(key++, new BondEnergy("H", "C", IBond.Order.SINGLE, 411));
        bondEngergies.put(key++, new BondEnergy("H", "Si", IBond.Order.SINGLE, 318));
        bondEngergies.put(key++, new BondEnergy("H", "Ge", IBond.Order.SINGLE, 288));
        bondEngergies.put(key++, new BondEnergy("H", "Sn", IBond.Order.SINGLE, 251));
        bondEngergies.put(key++, new BondEnergy("H", "N", IBond.Order.SINGLE, 386));
        bondEngergies.put(key++, new BondEnergy("H", "P", IBond.Order.SINGLE, 322));
        bondEngergies.put(key++, new BondEnergy("H", "As", IBond.Order.SINGLE, 247));
        bondEngergies.put(key++, new BondEnergy("H", "O", IBond.Order.SINGLE, 459));
        bondEngergies.put(key++, new BondEnergy("H", "S", IBond.Order.SINGLE, 363));
        bondEngergies.put(key++, new BondEnergy("H", "Se", IBond.Order.SINGLE, 276));
        bondEngergies.put(key++, new BondEnergy("H", "Te", IBond.Order.SINGLE, 238));
        bondEngergies.put(key++, new BondEnergy("H", "F", IBond.Order.SINGLE, 565));
        bondEngergies.put(key++, new BondEnergy("H", "Cl", IBond.Order.SINGLE, 428));
        bondEngergies.put(key++, new BondEnergy("H", "Br", IBond.Order.SINGLE, 362));
        bondEngergies.put(key++, new BondEnergy("H", "I", IBond.Order.SINGLE, 295));
        return key;
    }

    private int setGroup13(int key) {
        bondEngergies.put(key++, new BondEnergy("B", "B", IBond.Order.SINGLE, 293));
        bondEngergies.put(key++, new BondEnergy("B", "O", IBond.Order.SINGLE, 536));
        bondEngergies.put(key++, new BondEnergy("B", "F", IBond.Order.SINGLE, 613));
        bondEngergies.put(key++, new BondEnergy("B", "Cl", IBond.Order.SINGLE, 456));
        bondEngergies.put(key++, new BondEnergy("B", "Br", IBond.Order.SINGLE, 377));
        return key;
    }

    private int setGroup14Part1(int key) {
        bondEngergies.put(key++, new BondEnergy("C", "C", IBond.Order.SINGLE, 346));
        bondEngergies.put(key++, new BondEnergy("C", "C", IBond.Order.DOUBLE, 602));
        bondEngergies.put(key++, new BondEnergy("C", "C", IBond.Order.TRIPLE, 835));
        bondEngergies.put(key++, new BondEnergy("C", "Si", IBond.Order.SINGLE, 318));
        bondEngergies.put(key++, new BondEnergy("C", "Ge", IBond.Order.SINGLE, 238));
        bondEngergies.put(key++, new BondEnergy("C", "Sn", IBond.Order.SINGLE, 192));
        bondEngergies.put(key++, new BondEnergy("C", "Pb", IBond.Order.SINGLE, 130));
        bondEngergies.put(key++, new BondEnergy("C", "N", IBond.Order.SINGLE, 305));
        bondEngergies.put(key++, new BondEnergy("C", "N", IBond.Order.DOUBLE, 615));
        bondEngergies.put(key++, new BondEnergy("C", "N", IBond.Order.TRIPLE, 887));
        bondEngergies.put(key++, new BondEnergy("C", "P", IBond.Order.SINGLE, 264));
        bondEngergies.put(key++, new BondEnergy("C", "O", IBond.Order.SINGLE, 358));
        bondEngergies.put(key++, new BondEnergy("C", "O", IBond.Order.DOUBLE, 799));
        bondEngergies.put(key++, new BondEnergy("C", "O", IBond.Order.TRIPLE, 1072));
        bondEngergies.put(key++, new BondEnergy("C", "B", IBond.Order.SINGLE, 356));
        bondEngergies.put(key++, new BondEnergy("C", "S", IBond.Order.SINGLE, 272));
        bondEngergies.put(key++, new BondEnergy("C", "S", IBond.Order.DOUBLE, 573));
        bondEngergies.put(key++, new BondEnergy("C", "F", IBond.Order.SINGLE, 485));
        bondEngergies.put(key++, new BondEnergy("C", "Cl", IBond.Order.SINGLE, 327));
        bondEngergies.put(key++, new BondEnergy("C", "Br", IBond.Order.SINGLE, 285));
        bondEngergies.put(key++, new BondEnergy("C", "I", IBond.Order.SINGLE, 213));
        return key;
    }

    private int setGroup14Part2(int key) {
        bondEngergies.put(key++, new BondEnergy("Si", "Si", IBond.Order.SINGLE, 222));
        bondEngergies.put(key++, new BondEnergy("Si", "N", IBond.Order.SINGLE, 355));
        bondEngergies.put(key++, new BondEnergy("Si", "O", IBond.Order.SINGLE, 452));
        bondEngergies.put(key++, new BondEnergy("Si", "S", IBond.Order.SINGLE, 293));
        bondEngergies.put(key++, new BondEnergy("Si", "F", IBond.Order.SINGLE, 565));
        bondEngergies.put(key++, new BondEnergy("Si", "Cl", IBond.Order.SINGLE, 381));
        bondEngergies.put(key++, new BondEnergy("Si", "Br", IBond.Order.SINGLE, 310));
        bondEngergies.put(key++, new BondEnergy("Si", "I", IBond.Order.SINGLE, 234));
        bondEngergies.put(key++, new BondEnergy("Ge", "Ge", IBond.Order.SINGLE, 188));
        bondEngergies.put(key++, new BondEnergy("Ge", "N", IBond.Order.SINGLE, 257));
        bondEngergies.put(key++, new BondEnergy("Ge", "F", IBond.Order.SINGLE, 470));
        bondEngergies.put(key++, new BondEnergy("Ge", "Cl", IBond.Order.SINGLE, 349));
        bondEngergies.put(key++, new BondEnergy("Ge", "Br", IBond.Order.SINGLE, 276));
        bondEngergies.put(key++, new BondEnergy("Ge", "I", IBond.Order.SINGLE, 212));
        bondEngergies.put(key++, new BondEnergy("Sn", "F", IBond.Order.SINGLE, 414));
        bondEngergies.put(key++, new BondEnergy("Sn", "Cl", IBond.Order.SINGLE, 323));
        bondEngergies.put(key++, new BondEnergy("Sn", "Br", IBond.Order.SINGLE, 273));
        bondEngergies.put(key++, new BondEnergy("Sn", "I", IBond.Order.SINGLE, 205));
        bondEngergies.put(key++, new BondEnergy("Pb", "F", IBond.Order.SINGLE, 313));
        bondEngergies.put(key++, new BondEnergy("Pb", "Cl", IBond.Order.SINGLE, 243));
        bondEngergies.put(key++, new BondEnergy("Pb", "Br", IBond.Order.SINGLE, 201));
        bondEngergies.put(key++, new BondEnergy("Pb", "I", IBond.Order.SINGLE, 142));
        return key;
    }

    private int setGroup15(int key) {
        bondEngergies.put(key++, new BondEnergy("N", "N", IBond.Order.SINGLE, 167));
        bondEngergies.put(key++, new BondEnergy("N", "N", IBond.Order.DOUBLE, 418));
        bondEngergies.put(key++, new BondEnergy("N", "N", IBond.Order.TRIPLE, 942));
        bondEngergies.put(key++, new BondEnergy("N", "O", IBond.Order.SINGLE, 201));
        bondEngergies.put(key++, new BondEnergy("N", "O", IBond.Order.DOUBLE, 607));
        bondEngergies.put(key++, new BondEnergy("N", "F", IBond.Order.SINGLE, 283));
        bondEngergies.put(key++, new BondEnergy("N", "Cl", IBond.Order.SINGLE, 313));
        bondEngergies.put(key++, new BondEnergy("P", "P", IBond.Order.SINGLE, 201));
        bondEngergies.put(key++, new BondEnergy("P", "O", IBond.Order.SINGLE, 335));
        bondEngergies.put(key++, new BondEnergy("P", "O", IBond.Order.DOUBLE, 544));
        bondEngergies.put(key++, new BondEnergy("P", "S", IBond.Order.DOUBLE, 335));
        bondEngergies.put(key++, new BondEnergy("P", "F", IBond.Order.SINGLE, 490));
        bondEngergies.put(key++, new BondEnergy("P", "Cl", IBond.Order.SINGLE, 326));
        bondEngergies.put(key++, new BondEnergy("P", "Br", IBond.Order.SINGLE, 264));
        bondEngergies.put(key++, new BondEnergy("P", "I", IBond.Order.SINGLE, 184));
        bondEngergies.put(key++, new BondEnergy("As", "As", IBond.Order.SINGLE, 146));
        bondEngergies.put(key++, new BondEnergy("As", "O", IBond.Order.SINGLE, 301));
        bondEngergies.put(key++, new BondEnergy("As", "F", IBond.Order.SINGLE, 484));
        bondEngergies.put(key++, new BondEnergy("As", "Cl", IBond.Order.SINGLE, 322));
        bondEngergies.put(key++, new BondEnergy("As", "Br", IBond.Order.SINGLE, 458));
        bondEngergies.put(key++, new BondEnergy("As", "I", IBond.Order.SINGLE, 200));
        bondEngergies.put(key++, new BondEnergy("Sb", "Sb", IBond.Order.SINGLE, 121));
        bondEngergies.put(key++, new BondEnergy("Sb", "F", IBond.Order.SINGLE, 440));
        bondEngergies.put(key++, new BondEnergy("Sb", "Cl", IBond.Order.SINGLE, 248));
        bondEngergies.put(key++, new BondEnergy("Sb", "Cl", IBond.Order.SINGLE, 315));
        return key;
    }

    private int setGroup16(int key) {
        bondEngergies.put(key++, new BondEnergy("O", "O", IBond.Order.SINGLE, 142));
        bondEngergies.put(key++, new BondEnergy("O", "O", IBond.Order.DOUBLE, 494));
        bondEngergies.put(key++, new BondEnergy("O", "F", IBond.Order.SINGLE, 190));
        bondEngergies.put(key++, new BondEnergy("O", "S", IBond.Order.SINGLE, 365));
        bondEngergies.put(key++, new BondEnergy("S", "O", IBond.Order.DOUBLE, 522));
        bondEngergies.put(key++, new BondEnergy("S", "S", IBond.Order.SINGLE, 226));
        bondEngergies.put(key++, new BondEnergy("S", "S", IBond.Order.DOUBLE, 425));
        bondEngergies.put(key++, new BondEnergy("S", "F", IBond.Order.SINGLE, 284));
        bondEngergies.put(key++, new BondEnergy("S", "Cl", IBond.Order.SINGLE, 255));
        bondEngergies.put(key++, new BondEnergy("Se", "Se", IBond.Order.SINGLE, 172));
        bondEngergies.put(key++, new BondEnergy("Se", "Se", IBond.Order.DOUBLE, 272));
        return key;
    }

    private int setGroup17(int key) {
        bondEngergies.put(key++, new BondEnergy("F", "F", IBond.Order.SINGLE, 155));
        bondEngergies.put(key++, new BondEnergy("Cl", "Cl", IBond.Order.SINGLE, 240));
        bondEngergies.put(key++, new BondEnergy("Br", "Br", IBond.Order.SINGLE, 190));
        bondEngergies.put(key++, new BondEnergy("I", "I", IBond.Order.SINGLE, 148));
        bondEngergies.put(key++, new BondEnergy("At", "At", IBond.Order.SINGLE, 116));
        bondEngergies.put(key++, new BondEnergy("I", "O", IBond.Order.SINGLE, 201));
        bondEngergies.put(key++, new BondEnergy("I", "F", IBond.Order.SINGLE, 273));
        bondEngergies.put(key++, new BondEnergy("I", "Cl", IBond.Order.SINGLE, 208));
        bondEngergies.put(key++, new BondEnergy("I", "Br", IBond.Order.SINGLE, 175));
        return key;
    }

    private int setGroup18(int key) {
        bondEngergies.put(key++, new BondEnergy("Kr", "F", IBond.Order.SINGLE, 50));
        bondEngergies.put(key++, new BondEnergy("Xe", "O", IBond.Order.SINGLE, 84));
        bondEngergies.put(key++, new BondEnergy("Xe", "F", IBond.Order.SINGLE, 130));
        return key;
    }
}

