/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smarts;

import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.smarts.Smarts;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class SmartsPattern
extends Pattern {
    private final IAtomContainer query;
    private final Pattern pattern;
    private boolean doPrep = true;
    private static final Aromaticity arom = new Aromaticity(ElectronDonation.daylight(), Cycles.or(Cycles.all(), Cycles.relevant()));

    private SmartsPattern(String smarts, IChemObjectBuilder builder) {
        this.query = new QueryAtomContainer(builder);
        if (!Smarts.parse(this.query, smarts)) {
            throw new IllegalArgumentException("Could not parse SMARTS: " + smarts + "\n" + Smarts.getLastErrorMesg() + "\n" + Smarts.getLastErrorLocation());
        }
        this.pattern = Pattern.findSubstructure(this.query);
    }

    public static void prepare(IAtomContainer target) {
        try {
            Cycles.markRingAtomsAndBonds(target);
            arom.apply(target);
        }
        catch (CDKException e) {
            LoggingToolFactory.createLoggingTool(SmartsPattern.class).error(e);
        }
    }

    public SmartsPattern setPrepare(boolean doPrep) {
        this.doPrep = doPrep;
        return this;
    }

    @Override
    public int[] match(IAtomContainer container) {
        return this.matchAll(container).first();
    }

    @Override
    public Mappings matchAll(IAtomContainer target) {
        if (this.doPrep) {
            SmartsPattern.prepare(target);
        }
        return this.pattern.matchAll(target);
    }

    public static SmartsPattern create(String smarts, IChemObjectBuilder builder) {
        return new SmartsPattern(smarts, builder);
    }

    public static SmartsPattern create(String smarts) {
        return new SmartsPattern(smarts, null);
    }
}

