/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.math.IFunction;

public class GraphRendererModel {
    private double xmin = -1.0;
    private double xmax = 1.0;
    private double ymin = -1.0;
    private double ymax = 1.0;
    private String title = "Main title";
    private String xtitle = "X title";
    private String ytitle = "Y title";
    private List<IFunction> functions = new ArrayList<IFunction>();
    private List<Color> colors = new ArrayList<Color>();
    public static final int NORMAL = 0;
    public static final int BELOWAREA = 1;
    public static final int OVERAREA = 2;
    private int displaymode = 0;

    public void setX(double xmin, double xmax) {
        if (xmin < xmax) {
            this.xmin = xmin;
            this.xmax = xmax;
        }
    }

    public void setY(double ymin, double ymax) {
        if (ymin < ymax) {
            this.ymin = ymin;
            this.ymax = ymax;
        }
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public void setTitle(String string) {
        if (string != null) {
            this.title = string;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setXTitle(String string) {
        if (string != null) {
            this.xtitle = string;
        }
    }

    public String getXTitle() {
        return this.xtitle;
    }

    public void setYTitle(String string) {
        if (string != null) {
            this.ytitle = string;
        }
    }

    public String getYTitle() {
        return this.ytitle;
    }

    public void setDisplayMode(int mode) {
        if (0 <= mode && mode <= 2) {
            this.displaymode = mode;
        }
    }

    public int getDisplayMode() {
        return this.displaymode;
    }

    public void addFunction(IFunction function) {
        if (function != null && !this.functions.contains(function)) {
            this.functions.add(function);
            this.colors.add(Color.black);
        }
    }

    public void addFunction(IFunction function, Color color) {
        if (function != null && !this.functions.contains(function)) {
            this.functions.add(function);
            this.colors.add(color);
        } else {
            this.colors.set(this.functions.indexOf(function), color);
        }
    }

    public int getFunctionsSize() {
        return this.functions.size();
    }

    public IFunction getFunction(int index) {
        return this.functions.get(index);
    }

    public Color getFunctionColor(int index) {
        return this.colors.get(index);
    }
}

