/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.io.IOException;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.renderer.RendererModel;

public abstract class SymbolVisibility {
    public abstract boolean visible(IAtom var1, List<IBond> var2, RendererModel var3);

    public static SymbolVisibility all() {
        return new SymbolVisibility(){

            @Override
            public boolean visible(IAtom atom, List<IBond> neighbors, RendererModel model) {
                return true;
            }
        };
    }

    public static SymbolVisibility iupacRecommendations() {
        return new IupacVisibility(true);
    }

    public static SymbolVisibility iupacRecommendationsWithoutTerminalCarbon() {
        return new IupacVisibility(false);
    }

    private static final class IupacVisibility
    extends SymbolVisibility {
        private boolean terminal = false;

        private IupacVisibility(boolean terminal) {
            this.terminal = terminal;
        }

        @Override
        public boolean visible(IAtom atom, List<IBond> bonds, RendererModel model) {
            IBond.Order bndord;
            Elements element = Elements.ofNumber(atom.getAtomicNumber());
            if (element != Elements.Carbon) {
                return true;
            }
            if (bonds.size() == 0) {
                return true;
            }
            if (bonds.size() == 1 && this.terminal) {
                return true;
            }
            if (!IupacVisibility.isFourValent(atom, bonds)) {
                return true;
            }
            Integer mass = atom.getMassNumber();
            if (mass != null && !IupacVisibility.isMajorIsotope(element.number(), mass)) {
                return true;
            }
            if (bonds.size() == 2 && bonds.get(0).getOrder() == bonds.get(1).getOrder() && ((bndord = bonds.get(0).getOrder()) == IBond.Order.DOUBLE || IupacVisibility.hasParallelBonds(atom, bonds))) {
                return true;
            }
            if (bonds.size() == 1) {
                Integer begHcnt = atom.getImplicitHydrogenCount();
                IAtom end = bonds.get(0).getOther(atom);
                Integer endHcnt = end.getImplicitHydrogenCount();
                if (begHcnt != null && endHcnt != null && begHcnt == 3 && endHcnt == 3) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isMajorIsotope(int number, int mass) {
            try {
                IIsotope isotope = Isotopes.getInstance().getMajorIsotope(number);
                return isotope != null && isotope.getMassNumber().equals(mass);
            }
            catch (IOException e) {
                return false;
            }
        }

        private static boolean isFourValent(IAtom atom, List<IBond> bonds) {
            Integer valence = atom.getImplicitHydrogenCount();
            if (valence == null) {
                return true;
            }
            for (IBond bond : bonds) {
                valence = valence + bond.getOrder().numeric();
            }
            return valence == 4;
        }

        private static boolean hasParallelBonds(IAtom atom, List<IBond> bonds) {
            if (bonds.size() != 2) {
                return false;
            }
            double thetaInRad = IupacVisibility.getAngle(atom, bonds.get(0), bonds.get(1));
            double thetaInDeg = Math.toDegrees(thetaInRad);
            double delta = Math.abs(thetaInDeg - 180.0);
            return delta < 8.0;
        }

        private static double getAngle(IAtom atom, IBond bond1, IBond bond2) {
            Point2d pA = atom.getPoint2d();
            Point2d pB = bond1.getOther(atom).getPoint2d();
            Point2d pC = bond2.getOther(atom).getPoint2d();
            Vector2d u = new Vector2d(pB.x - pA.x, pB.y - pA.y);
            Vector2d v = new Vector2d(pC.x - pA.x, pC.y - pA.y);
            return u.angle(v);
        }
    }
}

